/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.social.linkedin.api.CodeAndName;
import org.springframework.social.linkedin.api.Location;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class JobPositionMixin {
    @JsonProperty
    CodeAndName experienceLevel;
    @JsonProperty
    @JsonDeserialize(using=CodeAndNameListDeserializer.class)
    List<CodeAndName> industries;
    @JsonProperty
    @JsonDeserialize(using=CodeAndNameListDeserializer.class)
    List<CodeAndName> jobFunctions;
    @JsonProperty
    CodeAndName jobType;

    @JsonCreator
    JobPositionMixin(@JsonProperty(value="title") String title, @JsonProperty(value="location") Location location) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CodeAndNameListDeserializer
    extends JsonDeserializer<List<CodeAndName>> {
        private CodeAndNameListDeserializer() {
        }

        public List<CodeAndName> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken() && (dataNode = jp.readValueAsTree().get("values")) != null) {
                return (List)mapper.readValue(dataNode, (TypeReference)new TypeReference<List<CodeAndName>>(){});
            }
            return null;
        }
    }
}

