/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import java.io.IOException;
import java.lang.reflect.Field;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.social.linkedin.api.Company;
import org.springframework.social.linkedin.api.LinkedInNetworkUpdate;
import org.springframework.social.linkedin.api.UpdateAction;
import org.springframework.social.linkedin.api.UpdateContent;
import org.springframework.social.linkedin.api.UpdateContentCompany;
import org.springframework.social.linkedin.api.UpdateContentConnection;
import org.springframework.social.linkedin.api.UpdateContentFollow;
import org.springframework.social.linkedin.api.UpdateContentGroup;
import org.springframework.social.linkedin.api.UpdateContentPersonActivity;
import org.springframework.social.linkedin.api.UpdateContentRecommendation;
import org.springframework.social.linkedin.api.UpdateContentShare;
import org.springframework.social.linkedin.api.UpdateContentStatus;
import org.springframework.social.linkedin.api.UpdateContentViral;
import org.springframework.social.linkedin.api.UpdateType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LinkedInNetworkUpdateListDeserializer
extends JsonDeserializer<LinkedInNetworkUpdate> {
    LinkedInNetworkUpdateListDeserializer() {
    }

    public LinkedInNetworkUpdate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDeserializationConfig(ctxt.getConfig());
        jp.setCodec((ObjectCodec)mapper);
        JsonNode dataNode = jp.readValueAsTree();
        if (dataNode != null) {
            LinkedInNetworkUpdate linkedInNetworkUpdate = (LinkedInNetworkUpdate)mapper.readValue(dataNode, (TypeReference)new TypeReference<LinkedInNetworkUpdate>(){});
            UpdateContent updatedContent = null;
            UpdateType type = linkedInNetworkUpdate.getUpdateType();
            JsonNode updatedNode = dataNode.get("updateContent");
            JsonNode person = updatedNode.get("person");
            if (type == UpdateType.MSFC) {
                person = updatedNode.get("companyPersonUpdate").get("person");
            }
            switch (type) {
                case CONN: {
                    updatedContent = (UpdateContent)mapper.readValue(person, (TypeReference)new TypeReference<UpdateContentConnection>(){});
                    break;
                }
                case STAT: {
                    updatedContent = (UpdateContent)mapper.readValue(person, (TypeReference)new TypeReference<UpdateContentStatus>(){});
                    break;
                }
                case JGRP: {
                    updatedContent = (UpdateContent)mapper.readValue(person, (TypeReference)new TypeReference<UpdateContentGroup>(){});
                    break;
                }
                case PREC: 
                case SVPR: {
                    updatedContent = (UpdateContent)mapper.readValue(person, (TypeReference)new TypeReference<UpdateContentRecommendation>(){});
                    break;
                }
                case APPM: {
                    updatedContent = (UpdateContent)mapper.readValue(person, (TypeReference)new TypeReference<UpdateContentPersonActivity>(){});
                    break;
                }
                case MSFC: {
                    updatedContent = (UpdateContent)mapper.readValue(person, (TypeReference)new TypeReference<UpdateContentFollow>(){});
                    break;
                }
                case VIRL: {
                    updatedContent = (UpdateContent)mapper.readValue(person, (TypeReference)new TypeReference<UpdateContentViral>(){});
                    break;
                }
                case SHAR: {
                    updatedContent = (UpdateContent)mapper.readValue(person, (TypeReference)new TypeReference<UpdateContentShare>(){});
                    break;
                }
                case CMPY: {
                    updatedContent = (UpdateContent)mapper.readValue(updatedNode, (TypeReference)new TypeReference<UpdateContentCompany>(){});
                    break;
                }
                default: {
                    try {
                        updatedContent = (UpdateContent)mapper.readValue(person, (TypeReference)new TypeReference<UpdateContent>(){});
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            try {
                Field f = LinkedInNetworkUpdate.class.getDeclaredField("updateContent");
                f.setAccessible(true);
                f.set(linkedInNetworkUpdate, updatedContent);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (type == UpdateType.MSFC) {
                String action = updatedNode.get("companyPersonUpdate").get("action").get("code").asText();
                try {
                    Field f = UpdateContentFollow.class.getDeclaredField("action");
                    f.setAccessible(true);
                    f.set(updatedContent, action);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                Company company = (Company)mapper.readValue(updatedNode.get("company"), (TypeReference)new TypeReference<Company>(){});
                try {
                    Field f = UpdateContentFollow.class.getDeclaredField("following");
                    f.setAccessible(true);
                    f.set(updatedContent, company);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (type == UpdateType.VIRL) {
                Field f;
                JsonNode originalUpdate = updatedNode.path("updateAction").path("originalUpdate");
                UpdateAction updateAction = (UpdateAction)mapper.readValue(originalUpdate, (TypeReference)new TypeReference<UpdateAction>(){});
                String code = updatedNode.path("updateAction").path("action").path("code").getTextValue();
                try {
                    f = UpdateAction.class.getDeclaredField("action");
                    f.setAccessible(true);
                    f.set(updateAction, code);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try {
                    f = UpdateContentViral.class.getDeclaredField("updateAction");
                    f.setAccessible(true);
                    f.set(updatedContent, updateAction);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return linkedInNetworkUpdate;
        }
        return null;
    }
}

