/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.social.linkedin.api.LinkedInProfile;
import org.springframework.social.linkedin.api.Post;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class PostMixin {
    @JsonProperty
    Date creationTimestamp;
    @JsonProperty
    Post.PostRelation relationToViewer;
    @JsonProperty
    String summary;
    @JsonProperty
    @JsonDeserialize(using=LikesListDeserializer.class)
    List<LinkedInProfile> likes;

    @JsonCreator
    PostMixin(@JsonProperty(value="creator") LinkedInProfile creator, @JsonProperty(value="id") String id, @JsonProperty(value="title") String title, @JsonProperty(value="type") @JsonDeserialize(using=PostTypeDeserializer.class) Post.PostType type) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LikesListDeserializer
    extends JsonDeserializer<List<LinkedInProfile>> {
        private LikesListDeserializer() {
        }

        public List<LinkedInProfile> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            ArrayList<LinkedInProfile> likes = new ArrayList<LinkedInProfile>();
            if (jp.hasCurrentToken() && (dataNode = jp.readValueAsTree().get("values")) != null) {
                for (JsonNode d : dataNode) {
                    LinkedInProfile p = (LinkedInProfile)mapper.readValue(d.path("person"), (TypeReference)new TypeReference<LinkedInProfile>(){});
                    likes.add(p);
                }
            }
            return likes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PostTypeDeserializer
    extends JsonDeserializer<Post.PostType> {
        private PostTypeDeserializer() {
        }

        public Post.PostType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = jp.readValueAsTree();
            return Post.PostType.valueOf(node.get("code").getTextValue().replace('-', '_').toUpperCase());
        }
    }
}

