/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.springframework.social.linkedin.api.Group;
import org.springframework.social.linkedin.api.Post;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
abstract class PostRelationMixin {
    @JsonCreator
    PostRelationMixin(@JsonProperty(value="availableActions") @JsonDeserialize(using=AvailableActionDeserializer.class) List<Group.GroupAvailableAction> availableActions, @JsonProperty(value="isFollowing") Boolean isFollowing, @JsonProperty(value="isLiked") Boolean isLiked) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AvailableActionDeserializer
    extends JsonDeserializer<List<Post.PostAvailableAction>> {
        private AvailableActionDeserializer() {
        }

        public List<Post.PostAvailableAction> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            ArrayList<Post.PostAvailableAction> actions = new ArrayList<Post.PostAvailableAction>();
            if (jp.hasCurrentToken() && (dataNode = jp.readValueAsTree().get("values")) != null) {
                for (JsonNode d : dataNode) {
                    String s = d.path("code").getTextValue();
                    if (s == null) continue;
                    actions.add(Post.PostAvailableAction.valueOf(s.replace('-', '_').toUpperCase()));
                }
            }
            return actions;
        }
    }
}

