/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.springframework.social.linkedin.api.LinkedInProfile;
import org.springframework.social.linkedin.api.Recommendation;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class RecommendationMixin {
    @JsonCreator
    RecommendationMixin(@JsonProperty(value="id") String id, @JsonProperty(value="recommendationSnippet") String recommendationSnippet, @JsonProperty(value="recommendationText") String recommendationText, @JsonProperty(value="recommendationType") @JsonDeserialize(using=RecommendationTypeDeserializer.class) Recommendation.RecommendationType recommendationType, @JsonProperty(value="recommender") LinkedInProfile recommender, @JsonProperty(value="recommendee") LinkedInProfile recommendee) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecommendationTypeDeserializer
    extends JsonDeserializer<Recommendation.RecommendationType> {
        private RecommendationTypeDeserializer() {
        }

        public Recommendation.RecommendationType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = jp.readValueAsTree();
            return Recommendation.RecommendationType.valueOf(node.get("code").getTextValue().replace('-', '_').toUpperCase());
        }
    }
}

