/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.social.linkedin.api.Comment;
import org.springframework.social.linkedin.api.LinkedInProfile;
import org.springframework.social.linkedin.api.UpdateContent;
import org.springframework.social.linkedin.api.UpdateContentCompany;
import org.springframework.social.linkedin.api.UpdateContentShare;
import org.springframework.social.linkedin.api.UpdateType;
import org.springframework.social.linkedin.api.impl.json.LikesListDeserializer;
import org.springframework.social.linkedin.api.impl.json.UpdateTypeDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class UpdateActionMixin {
    @JsonProperty(value="isCommentable")
    boolean commentable;
    @JsonProperty(value="isLikable")
    boolean likeable;
    @JsonProperty(value="isLiked")
    boolean liked;
    @JsonProperty(value="numLikes")
    int numLikes;
    @JsonProperty(value="likes")
    @JsonDeserialize(using=LikesListDeserializer.class)
    List<LinkedInProfile> likes;
    @JsonProperty(value="updateComments")
    @JsonDeserialize(using=CommentsListDeserializer.class)
    List<Comment> updateComments;
    @JsonProperty(value="updateContent")
    @JsonDeserialize(using=UpdateContentDeserializer.class)
    UpdateContent updateContent;

    @JsonCreator
    UpdateActionMixin(@JsonProperty(value="timestamp") Date timestamp, @JsonProperty(value="updateKey") String updateKey, @JsonProperty(value="updateType") @JsonDeserialize(using=UpdateTypeDeserializer.class) UpdateType updateType) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateContentDeserializer
    extends JsonDeserializer<UpdateContent> {
        private UpdateContentDeserializer() {
        }

        public UpdateContent deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            JsonNode content = jp.readValueAsTree();
            JsonNode person = content.get("person");
            JsonNode company = content.get("company");
            if (person != null) {
                return (UpdateContent)mapper.readValue(person, (TypeReference)new TypeReference<UpdateContentShare>(){});
            }
            if (company != null) {
                return (UpdateContent)mapper.readValue(content, (TypeReference)new TypeReference<UpdateContentCompany>(){});
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommentsListDeserializer
    extends JsonDeserializer<List<Comment>> {
        private CommentsListDeserializer() {
        }

        public List<Comment> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDeserializationConfig(ctxt.getConfig());
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken() && (dataNode = jp.readValueAsTree().get("values")) != null) {
                return (List)mapper.readValue(dataNode, (TypeReference)new TypeReference<List<Comment>>(){});
            }
            return null;
        }
    }
}

