/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.connect;

import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.ConnectionValues;
import org.springframework.social.connect.UserProfile;
import org.springframework.social.connect.UserProfileBuilder;
import org.springframework.social.linkedin.api.LinkedIn;
import org.springframework.social.linkedin.api.LinkedInProfile;
import org.springframework.web.client.HttpClientErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedInAdapter
implements ApiAdapter<LinkedIn> {
    public boolean test(LinkedIn linkedin) {
        try {
            linkedin.profileOperations().getUserProfile();
            return true;
        }
        catch (HttpClientErrorException e) {
            return false;
        }
    }

    public void setConnectionValues(LinkedIn linkedin, ConnectionValues values) {
        LinkedInProfile profile = linkedin.profileOperations().getUserProfile();
        values.setProviderUserId(profile.getId());
        values.setDisplayName(profile.getFirstName() + " " + profile.getLastName());
        values.setProfileUrl(profile.getPublicProfileUrl());
        values.setImageUrl(profile.getProfilePictureUrl());
    }

    public UserProfile fetchUserProfile(LinkedIn linkedin) {
        LinkedInProfile profile = linkedin.profileOperations().getUserProfile();
        return new UserProfileBuilder().setName(profile.getFirstName() + " " + profile.getLastName()).build();
    }

    public void updateStatus(LinkedIn linkedin, String message) {
    }
}

