/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.List;
import org.springframework.social.linkedin.api.CodeAndName;
import org.springframework.social.linkedin.api.Location;
import org.springframework.social.linkedin.api.impl.json.DeserializationUtils;
import org.springframework.social.linkedin.api.impl.json.LinkedInObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class JobPositionMixin
extends LinkedInObjectMixin {
    @JsonProperty
    CodeAndName experienceLevel;
    @JsonProperty
    @JsonDeserialize(using=CodeAndNameListDeserializer.class)
    List<CodeAndName> industries;
    @JsonProperty
    @JsonDeserialize(using=CodeAndNameListDeserializer.class)
    List<CodeAndName> jobFunctions;
    @JsonProperty
    CodeAndName jobType;

    @JsonCreator
    JobPositionMixin(@JsonProperty(value="title") String title, @JsonProperty(value="location") Location location) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CodeAndNameListDeserializer
    extends JsonDeserializer<List<CodeAndName>> {
        private CodeAndNameListDeserializer() {
        }

        public List<CodeAndName> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<CodeAndName>>(){});
        }
    }
}

