/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.test.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.social.test.client.MockClientHttpResponse;
import org.springframework.social.test.client.ResponseCreator;
import org.springframework.util.Assert;

public abstract class ResponseCreators {
    private ResponseCreators() {
    }

    public static ResponseCreator withResponse(final String responseBody, final HttpHeaders headers, final HttpStatus statusCode, final String statusText) {
        Assert.notNull((Object)responseBody, (String)"'responseBody' must not be null");
        return new ResponseCreator(){

            public MockClientHttpResponse createResponse(ClientHttpRequest request) {
                return new MockClientHttpResponse(responseBody, headers, statusCode, statusText);
            }
        };
    }

    public static ResponseCreator withResponse(String responseBody, HttpHeaders headers) {
        return ResponseCreators.withResponse(responseBody, headers, HttpStatus.OK, "");
    }

    public static ResponseCreator withResponse(Resource responseBodyResource, HttpHeaders headers, HttpStatus statusCode, String statusText) {
        return ResponseCreators.withResponse(ResponseCreators.readResource(responseBodyResource), headers, statusCode, statusText);
    }

    public static ResponseCreator withResponse(Resource responseBody, HttpHeaders headers) {
        return ResponseCreators.withResponse(responseBody, headers, HttpStatus.OK, "");
    }

    private static String readResource(Resource resource) {
        StringBuilder resourceText = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream()));
            while (reader.ready()) {
                resourceText.append(reader.readLine() + "\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resourceText.toString();
    }
}

