/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.tripit.api.impl;

import java.util.List;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.social.oauth1.ProtectedResourceClientFactory;
import org.springframework.social.tripit.api.Trip;
import org.springframework.social.tripit.api.TripItApi;
import org.springframework.social.tripit.api.TripItProfile;
import org.springframework.social.tripit.api.impl.TripItModule;
import org.springframework.social.tripit.api.impl.TripList;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripItTemplate
implements TripItApi {
    private final RestTemplate restTemplate;

    public TripItTemplate(String apiKey, String apiSecret, String accessToken, String accessTokenSecret) {
        this.restTemplate = ProtectedResourceClientFactory.create((String)apiKey, (String)apiSecret, (String)accessToken, (String)accessTokenSecret);
        this.registerTwitterModule(this.restTemplate);
    }

    @Override
    public String getProfileId() {
        return this.getUserProfile().getId();
    }

    @Override
    public String getProfileUrl() {
        return this.getUserProfile().getProfileUrl();
    }

    @Override
    public TripItProfile getUserProfile() {
        return (TripItProfile)this.restTemplate.getForObject("https://api.tripit.com/v1/get/profile?format=json", TripItProfile.class, new Object[0]);
    }

    @Override
    public List<Trip> getUpcomingTrips() {
        return ((TripList)this.restTemplate.getForObject("https://api.tripit.com/v1/list/trip/traveler/true/past/false?format=json", TripList.class, new Object[0])).getList();
    }

    protected RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    private void registerTwitterModule(RestTemplate restTemplate) {
        List converters = restTemplate.getMessageConverters();
        for (HttpMessageConverter converter : converters) {
            if (!(converter instanceof MappingJacksonHttpMessageConverter)) continue;
            MappingJacksonHttpMessageConverter jsonConverter = (MappingJacksonHttpMessageConverter)converter;
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerModule((Module)new TripItModule());
            jsonConverter.setObjectMapper(objectMapper);
        }
    }
}

