/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.tripit.api.impl;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

@JsonIgnoreProperties(ignoreUnknown=true)
class TripMixin {
    private static SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd", Locale.US);

    @JsonCreator
    public TripMixin(@JsonProperty(value="id") long id, @JsonProperty(value="display_name") String displayName, @JsonProperty(value="primary_location") String primaryLocation, @JsonProperty(value="start_date") @JsonDeserialize(using=TripDateDeserializer.class) Date startDate, @JsonProperty(value="end_date") @JsonDeserialize(using=TripDateDeserializer.class) Date endDate, @JsonProperty(value="relative_url") String tripPath) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TripDateDeserializer
    extends JsonDeserializer<Date> {
        private TripDateDeserializer() {
        }

        public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                return DATE_FORMATTER.parse(jp.getText());
            }
            catch (ParseException e) {
                return new Date();
            }
        }
    }
}

