/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.tripit.connect;

import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.ConnectionValues;
import org.springframework.social.connect.UserProfile;
import org.springframework.social.connect.UserProfileBuilder;
import org.springframework.social.tripit.api.TripItApi;
import org.springframework.social.tripit.api.TripItProfile;
import org.springframework.web.client.HttpClientErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripItApiAdapter
implements ApiAdapter<TripItApi> {
    public boolean test(TripItApi api) {
        try {
            api.getUserProfile();
            return true;
        }
        catch (HttpClientErrorException e) {
            return false;
        }
    }

    public void setConnectionValues(TripItApi api, ConnectionValues values) {
        TripItProfile profile = api.getUserProfile();
        values.setProviderUserId(profile.getId());
        values.setDisplayName(profile.getScreenName());
        values.setProfileUrl(profile.getProfileUrl());
        values.setImageUrl(profile.getProfileImageUrl());
    }

    public UserProfile fetchUserProfile(TripItApi api) {
        TripItProfile profile = api.getUserProfile();
        return new UserProfileBuilder().setName(profile.getPublicDisplayName()).setEmail(profile.getEmailAddress()).setUsername(profile.getScreenName()).build();
    }

    public void updateStatus(TripItApi api, String message) {
    }
}

