/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.DuplicateStatusException;
import org.springframework.social.InternalServerErrorException;
import org.springframework.social.InvalidAuthorizationException;
import org.springframework.social.MissingAuthorizationException;
import org.springframework.social.NotAuthorizedException;
import org.springframework.social.OperationNotPermittedException;
import org.springframework.social.RateLimitExceededException;
import org.springframework.social.ResourceNotFoundException;
import org.springframework.social.RevokedAuthorizationException;
import org.springframework.social.ServerDownException;
import org.springframework.social.ServerOverloadedException;
import org.springframework.social.UncategorizedApiException;
import org.springframework.social.twitter.api.InvalidMessageRecipientException;
import org.springframework.social.twitter.api.MessageTooLongException;
import org.springframework.web.client.DefaultResponseErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TwitterErrorHandler
extends DefaultResponseErrorHandler {
    private static final String INVALID_MESSAGE_RECIPIENT_TEXT = "You cannot send messages to users who are not following you.";
    private static final String STATUS_TOO_LONG_TEXT = "Status is over 140 characters.";
    private static final String MESSAGE_TOO_LONG_TEXT = "The text of your direct message is over 140 characters";
    private static final String DUPLICATE_STATUS_TEXT = "Status is a duplicate.";
    private static final int ENHANCE_YOUR_CALM = 420;

    TwitterErrorHandler() {
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = response.getStatusCode();
        if (statusCode.series() == HttpStatus.Series.SERVER_ERROR) {
            this.handleServerErrors(statusCode);
        } else if (statusCode.series() == HttpStatus.Series.CLIENT_ERROR) {
            this.handleClientErrors(response);
        }
        try {
            super.handleError(response);
        }
        catch (Exception e) {
            throw new UncategorizedApiException("Error consuming Twitter REST API", (Throwable)e);
        }
    }

    private void handleClientErrors(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = response.getStatusCode();
        Map<String, Object> errorMap = this.extractErrorDetailsFromResponse(response);
        if (errorMap == null) {
            return;
        }
        String errorText = null;
        if (errorMap.containsKey("error")) {
            errorText = (String)errorMap.get("error");
        } else if (errorMap.containsKey("errors")) {
            List errors = (List)errorMap.get("errors");
            errorText = (String)((Map)errors.get(0)).get("message");
        }
        if (statusCode == HttpStatus.UNAUTHORIZED) {
            if (errorText == null) {
                throw new NotAuthorizedException(response.getStatusText());
            }
            if (errorText.equals("Could not authenticate you.")) {
                throw new MissingAuthorizationException();
            }
            if (errorText.equals("Could not authenticate with OAuth.")) {
                throw new RevokedAuthorizationException();
            }
            if (errorText.equals("Invalid / expired Token")) {
                throw new InvalidAuthorizationException(errorText);
            }
            throw new NotAuthorizedException(errorText);
        }
        if (statusCode == HttpStatus.FORBIDDEN) {
            if (errorText.equals(DUPLICATE_STATUS_TEXT) || errorText.contains("You already said that")) {
                throw new DuplicateStatusException(errorText);
            }
            if (errorText.equals(STATUS_TOO_LONG_TEXT) || errorText.contains(MESSAGE_TOO_LONG_TEXT)) {
                throw new MessageTooLongException(errorText);
            }
            if (errorText.equals(INVALID_MESSAGE_RECIPIENT_TEXT)) {
                throw new InvalidMessageRecipientException(errorText);
            }
            throw new OperationNotPermittedException(errorText);
        }
        if (statusCode == HttpStatus.NOT_FOUND) {
            throw new ResourceNotFoundException(errorText);
        }
        if (statusCode == HttpStatus.valueOf((int)420)) {
            throw new RateLimitExceededException();
        }
    }

    private void handleServerErrors(HttpStatus statusCode) throws IOException {
        if (statusCode == HttpStatus.INTERNAL_SERVER_ERROR) {
            throw new InternalServerErrorException("Something is broken at Twitter. Please see http://dev.twitter.com/pages/support to report the issue.");
        }
        if (statusCode == HttpStatus.BAD_GATEWAY) {
            throw new ServerDownException("Twitter is down or is being upgraded.");
        }
        if (statusCode == HttpStatus.SERVICE_UNAVAILABLE) {
            throw new ServerOverloadedException("Twitter is overloaded with requests. Try again later.");
        }
    }

    private Map<String, Object> extractErrorDetailsFromResponse(ClientHttpResponse response) throws IOException {
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        try {
            return (Map)mapper.readValue(response.getBody(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonParseException e) {
            return null;
        }
    }
}

