/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.social.twitter.api.StatusDetails;
import org.springframework.social.twitter.api.TimelineOperations;
import org.springframework.social.twitter.api.Tweet;
import org.springframework.social.twitter.api.TwitterProfile;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.PagingUtils;
import org.springframework.social.twitter.api.impl.TwitterProfileList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimelineTemplate
extends AbstractTwitterOperations
implements TimelineOperations {
    private final RestTemplate restTemplate;

    public TimelineTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
    }

    @Override
    public List<Tweet> getPublicTimeline() {
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/public_timeline.json"), TweetList.class);
    }

    @Override
    public List<Tweet> getHomeTimeline() {
        return this.getHomeTimeline(1, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getHomeTimeline(int page, int pageSize) {
        return this.getHomeTimeline(page, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getHomeTimeline(int page, int pageSize, long sinceId, long maxId) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, sinceId, maxId);
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/home_timeline.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getUserTimeline() {
        return this.getUserTimeline(1, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getUserTimeline(int page, int pageSize) {
        return this.getUserTimeline(page, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getUserTimeline(int page, int pageSize, long sinceId, long maxId) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, sinceId, maxId);
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/user_timeline.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getUserTimeline(String screenName) {
        return this.getUserTimeline(screenName, 1, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getUserTimeline(String screenName, int page, int pageSize) {
        return this.getUserTimeline(screenName, page, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getUserTimeline(String screenName, int page, int pageSize, long sinceId, long maxId) {
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, sinceId, maxId);
        parameters.set((Object)"screen_name", (Object)screenName);
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/user_timeline.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getUserTimeline(long userId) {
        return this.getUserTimeline(userId, 1, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getUserTimeline(long userId, int page, int pageSize) {
        return this.getUserTimeline(userId, page, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getUserTimeline(long userId, int page, int pageSize, long sinceId, long maxId) {
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, sinceId, maxId);
        parameters.set((Object)"user_id", (Object)String.valueOf(userId));
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/user_timeline.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getMentions() {
        return this.getMentions(1, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getMentions(int page, int pageSize) {
        return this.getMentions(page, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getMentions(int page, int pageSize, long sinceId, long maxId) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, sinceId, maxId);
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/mentions.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getRetweetedByMe() {
        return this.getRetweetedByMe(1, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetedByMe(int page, int pageSize) {
        return this.getRetweetedByMe(page, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetedByMe(int page, int pageSize, long sinceId, long maxId) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, sinceId, maxId);
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/retweeted_by_me.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getRetweetedByUser(long userId) {
        return this.getRetweetedByUser(userId, 1, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetedByUser(long userId, int page, int pageSize) {
        return this.getRetweetedByUser(userId, page, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetedByUser(long userId, int page, int pageSize, long sinceId, long maxId) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, sinceId, maxId);
        parameters.set((Object)"user_id", (Object)String.valueOf(userId));
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/retweeted_by_user.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getRetweetedByUser(String screenName) {
        return this.getRetweetedByUser(screenName, 1, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetedByUser(String screenName, int page, int pageSize) {
        return this.getRetweetedByUser(screenName, page, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetedByUser(String screenName, int page, int pageSize, long sinceId, long maxId) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, sinceId, maxId);
        parameters.set((Object)"screen_name", (Object)screenName);
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/retweeted_by_user.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getRetweetedToMe() {
        return this.getRetweetedToMe(1, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetedToMe(int page, int pageSize) {
        return this.getRetweetedToMe(page, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetedToMe(int page, int pageSize, long sinceId, long maxId) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, sinceId, maxId);
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/retweeted_to_me.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getRetweetedToUser(long userId) {
        return this.getRetweetedToUser(userId, 1, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetedToUser(long userId, int page, int pageSize) {
        return this.getRetweetedToUser(userId, page, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetedToUser(long userId, int page, int pageSize, long sinceId, long maxId) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, sinceId, maxId);
        parameters.set((Object)"user_id", (Object)String.valueOf(userId));
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/retweeted_to_user.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getRetweetedToUser(String screenName) {
        return this.getRetweetedToUser(screenName, 1, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetedToUser(String screenName, int page, int pageSize) {
        return this.getRetweetedToUser(screenName, page, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetedToUser(String screenName, int page, int pageSize, long sinceId, long maxId) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, sinceId, maxId);
        parameters.set((Object)"screen_name", (Object)screenName);
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/retweeted_to_user.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getRetweetsOfMe() {
        return this.getRetweetsOfMe(1, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetsOfMe(int page, int pageSize) {
        return this.getRetweetsOfMe(page, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getRetweetsOfMe(int page, int pageSize, long sinceId, long maxId) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, sinceId, maxId);
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/retweets_of_me.json", parameters), TweetList.class);
    }

    @Override
    public Tweet getStatus(long tweetId) {
        return (Tweet)this.restTemplate.getForObject(this.buildUri("statuses/show/" + tweetId + ".json"), Tweet.class);
    }

    @Override
    public Tweet updateStatus(String message) {
        return this.updateStatus(message, new StatusDetails());
    }

    @Override
    public Tweet updateStatus(String message, Resource media) {
        return this.updateStatus(message, media, new StatusDetails());
    }

    @Override
    public Tweet updateStatus(String message, StatusDetails details) {
        this.requireAuthorization();
        LinkedMultiValueMap tweetParams = new LinkedMultiValueMap();
        tweetParams.add((Object)"status", (Object)message);
        tweetParams.putAll(details.toParameterMap());
        return (Tweet)this.restTemplate.postForObject(this.buildUri("statuses/update.json"), (Object)tweetParams, Tweet.class);
    }

    @Override
    public Tweet updateStatus(String message, Resource media, StatusDetails details) {
        this.requireAuthorization();
        LinkedMultiValueMap tweetParams = new LinkedMultiValueMap();
        tweetParams.add((Object)"status", (Object)message);
        tweetParams.add((Object)"media", (Object)media);
        tweetParams.putAll(details.toParameterMap());
        return (Tweet)this.restTemplate.postForObject("https://upload.twitter.com/1/statuses/update_with_media.json", (Object)tweetParams, Tweet.class, new Object[0]);
    }

    @Override
    public void deleteStatus(long tweetId) {
        this.requireAuthorization();
        this.restTemplate.delete(this.buildUri("statuses/destroy/" + tweetId + ".json"));
    }

    @Override
    public void retweet(long tweetId) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        this.restTemplate.postForObject(this.buildUri("statuses/retweet/" + tweetId + ".json"), (Object)data, String.class);
    }

    @Override
    public List<Tweet> getRetweets(long tweetId) {
        return this.getRetweets(tweetId, 100);
    }

    @Override
    public List<Tweet> getRetweets(long tweetId, int count) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"count", (Object)String.valueOf(count));
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/retweets/" + tweetId + ".json", (MultiValueMap<String, String>)parameters), TweetList.class);
    }

    @Override
    public List<TwitterProfile> getRetweetedBy(long tweetId) {
        return this.getRetweetedBy(tweetId, 1, 100);
    }

    @Override
    public List<TwitterProfile> getRetweetedBy(long tweetId, int page, int pageSize) {
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, 0L, 0L);
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/" + tweetId + "/retweeted_by.json", parameters), TwitterProfileList.class);
    }

    @Override
    public List<Long> getRetweetedByIds(long tweetId) {
        return this.getRetweetedByIds(tweetId, 1, 100);
    }

    @Override
    public List<Long> getRetweetedByIds(long tweetId, int page, int pageSize) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, 0L, 0L);
        return (List)this.restTemplate.getForObject(this.buildUri("statuses/" + tweetId + "/retweeted_by/ids.json", parameters), LongList.class);
    }

    @Override
    public List<Tweet> getFavorites() {
        return this.getFavorites(1, 20);
    }

    @Override
    public List<Tweet> getFavorites(int page, int pageSize) {
        this.requireAuthorization();
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithCount(page, pageSize, 0L, 0L);
        return (List)this.restTemplate.getForObject(this.buildUri("favorites.json", parameters), TweetList.class);
    }

    @Override
    public void addToFavorites(long tweetId) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        this.restTemplate.postForObject(this.buildUri("favorites/create/" + tweetId + ".json"), (Object)data, String.class);
    }

    @Override
    public void removeFromFavorites(long tweetId) {
        this.requireAuthorization();
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        this.restTemplate.postForObject(this.buildUri("favorites/destroy/" + tweetId + ".json"), (Object)data, String.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TweetList
    extends ArrayList<Tweet> {
        private TweetList() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongList
    extends ArrayList<Long> {
        private LongList() {
        }
    }
}

