/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.springframework.social.twitter.api.Tweet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TweetDeserializer
extends JsonDeserializer<Tweet> {
    private static final String TIMELINE_DATE_FORMAT = "EEE MMM dd HH:mm:ss ZZZZZ yyyy";
    private static final String SEARCH_DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss Z";

    TweetDeserializer() {
    }

    public Tweet deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode tree = jp.readValueAsTree();
        long id = tree.get("id").asLong();
        String text = tree.get("text").asText();
        JsonNode fromUserNode = tree.get("user");
        String fromScreenName = null;
        long fromId = 0L;
        String fromImageUrl = null;
        String dateFormat = TIMELINE_DATE_FORMAT;
        if (fromUserNode != null) {
            fromScreenName = fromUserNode.get("screen_name").asText();
            fromId = fromUserNode.get("id").asLong();
            fromImageUrl = fromUserNode.get("profile_image_url").asText();
        } else {
            fromScreenName = tree.get("from_user").asText();
            fromId = tree.get("from_user_id").asLong();
            fromImageUrl = tree.get("profile_image_url").asText();
            dateFormat = SEARCH_DATE_FORMAT;
        }
        Date createdAt = this.toDate(tree.get("created_at").asText(), new SimpleDateFormat(dateFormat, Locale.ENGLISH));
        String source = tree.get("source").asText();
        JsonNode toUserIdNode = tree.get("in_reply_to_user_id");
        Long toUserId = toUserIdNode != null ? Long.valueOf(toUserIdNode.getLongValue()) : null;
        JsonNode languageCodeNode = tree.get("iso_language_code");
        String languageCode = languageCodeNode != null ? languageCodeNode.asText() : null;
        Tweet tweet = new Tweet(id, text, createdAt, fromScreenName, fromImageUrl, toUserId, fromId, languageCode, source);
        JsonNode inReplyToStatusIdNode = tree.get("in_reply_to_status_id");
        Long inReplyToStatusId = inReplyToStatusIdNode != null && !inReplyToStatusIdNode.isNull() ? Long.valueOf(inReplyToStatusIdNode.getLongValue()) : null;
        tweet.setInReplyToStatusId(inReplyToStatusId);
        JsonNode retweetCountNode = tree.get("retweet_count");
        Integer retweetCount = retweetCountNode != null && !retweetCountNode.isNull() ? Integer.valueOf(retweetCountNode.getIntValue()) : null;
        tweet.setRetweetCount(retweetCount);
        jp.skipChildren();
        return tweet;
    }

    private Date toDate(String dateString, DateFormat dateFormat) {
        if (dateString == null) {
            return null;
        }
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

