/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.util.Collection;
import java.util.List;
import org.springframework.social.twitter.api.BlockOperations;
import org.springframework.social.twitter.api.CursoredList;
import org.springframework.social.twitter.api.TwitterProfile;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.ArrayUtils;
import org.springframework.social.twitter.api.impl.CursorUtils;
import org.springframework.social.twitter.api.impl.CursoredLongList;
import org.springframework.social.twitter.api.impl.TwitterProfileList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlockTemplate
extends AbstractTwitterOperations
implements BlockOperations {
    private final RestTemplate restTemplate;

    public BlockTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
    }

    @Override
    public TwitterProfile block(long userId) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"user_id", (Object)String.valueOf(userId));
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("blocks/create.json"), (Object)request, TwitterProfile.class);
    }

    @Override
    public TwitterProfile block(String screenName) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"screen_name", (Object)screenName);
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("blocks/create.json"), (Object)request, TwitterProfile.class);
    }

    @Override
    public TwitterProfile unblock(long userId) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"user_id", (Object)String.valueOf(userId));
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("blocks/destroy.json"), (Object)request, TwitterProfile.class);
    }

    @Override
    public TwitterProfile unblock(String screenName) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"screen_name", (Object)screenName);
        return (TwitterProfile)this.restTemplate.postForObject(this.buildUri("blocks/destroy.json"), (Object)request, TwitterProfile.class);
    }

    @Override
    public CursoredList<TwitterProfile> getBlockedUsers() {
        return this.getBlockedUsersInCursor(-1L);
    }

    @Override
    public CursoredList<TwitterProfile> getBlockedUsersInCursor(long cursor) {
        this.requireAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)String.valueOf(cursor));
        CursoredList<Long> blockedUserIds = ((CursoredLongList)this.restTemplate.getForObject(this.buildUri("blocks/list.json", (MultiValueMap<String, String>)parameters), CursoredLongList.class)).getList();
        return this.getCursoredProfileList(blockedUserIds, blockedUserIds.getPreviousCursor(), blockedUserIds.getNextCursor());
    }

    @Override
    public CursoredList<Long> getBlockedUserIds() {
        return this.getBlockedUserIdsInCursor(-1L);
    }

    @Override
    public CursoredList<Long> getBlockedUserIdsInCursor(long cursor) {
        this.requireAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"cursor", (Object)String.valueOf(cursor));
        return ((CursoredLongList)this.restTemplate.getForObject(this.buildUri("blocks/ids.json", (MultiValueMap<String, String>)parameters), CursoredLongList.class)).getList();
    }

    private CursoredList<TwitterProfile> getCursoredProfileList(List<Long> userIds, long previousCursor, long nextCursor) {
        List<List<Long>> chunks = CursorUtils.chunkList(userIds, 100);
        CursoredList<TwitterProfile> users = new CursoredList<TwitterProfile>(userIds.size(), previousCursor, nextCursor);
        for (List<Long> userIdChunk : chunks) {
            String joinedIds = ArrayUtils.join(userIdChunk.toArray());
            users.addAll((Collection)this.restTemplate.getForObject(this.buildUri("users/lookup.json", "user_id", joinedIds), TwitterProfileList.class));
        }
        return users;
    }
}

