/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.springframework.social.twitter.api.RateLimitStatus;
import org.springframework.social.twitter.api.ResourceFamily;
import org.springframework.social.twitter.api.impl.RateLimitStatusHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateLimitStatusDeserializer
extends JsonDeserializer<RateLimitStatusHolder> {
    public RateLimitStatusHolder deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode tree = jp.readValueAsTree();
        if (null == tree || tree.isMissingNode() || tree.isNull()) {
            return null;
        }
        JsonNode resources = tree.get("resources");
        EnumMap<ResourceFamily, List<RateLimitStatus>> rateLimits = new EnumMap<ResourceFamily, List<RateLimitStatus>>(ResourceFamily.class);
        Iterator resourceFamilyIt = resources.getFields();
        while (resourceFamilyIt.hasNext()) {
            Map.Entry resourceFamilyNode = (Map.Entry)resourceFamilyIt.next();
            LinkedList<RateLimitStatus> rateLimitsList = new LinkedList<RateLimitStatus>();
            Iterator resourceEndpointIt = ((JsonNode)resourceFamilyNode.getValue()).getFields();
            while (resourceEndpointIt.hasNext()) {
                Map.Entry endpointNode = (Map.Entry)resourceEndpointIt.next();
                RateLimitStatus endpointLimit = new RateLimitStatus((String)endpointNode.getKey(), ((JsonNode)endpointNode.getValue()).get("limit").asInt(), ((JsonNode)endpointNode.getValue()).get("remaining").asInt(), ((JsonNode)endpointNode.getValue()).get("reset").asInt());
                rateLimitsList.add(endpointLimit);
            }
            rateLimits.put(ResourceFamily.getResourceFamily((String)resourceFamilyNode.getKey()), rateLimitsList);
        }
        return new RateLimitStatusHolder(rateLimits);
    }
}

