/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountSettingsData {
    private Long trendLocationWOEID;
    private Boolean sleepTimeEnabled;
    private Integer startSleepTime;
    private Integer endSleepTime;
    private String timeZone;
    private String lang;

    public AccountSettingsData trendLocationWOEID(long trendLocationWOEID) {
        this.trendLocationWOEID = trendLocationWOEID;
        return this;
    }

    public AccountSettingsData withSleepTimeEnabled(int startSleepTime, int endSleepTime) {
        this.sleepTimeEnabled = true;
        this.startSleepTime = startSleepTime;
        this.endSleepTime = endSleepTime;
        return this;
    }

    public AccountSettingsData withSleepTimeDisabled() {
        this.sleepTimeEnabled = false;
        this.startSleepTime = null;
        this.endSleepTime = null;
        return this;
    }

    public AccountSettingsData timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public AccountSettingsData language(String language) {
        this.lang = language;
        return this;
    }

    public MultiValueMap<String, Object> toRequestParameters() {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (this.trendLocationWOEID != null) {
            params.set((Object)"trend_location_woeid", (Object)this.trendLocationWOEID.toString());
        }
        if (this.sleepTimeEnabled != null) {
            params.set((Object)"sleep_time_enabled", (Object)this.sleepTimeEnabled.toString());
            if (this.sleepTimeEnabled.booleanValue()) {
                params.set((Object)"start_sleep_time", (Object)this.startSleepTime.toString());
                params.set((Object)"end_sleep_time", (Object)this.endSleepTime.toString());
            }
        }
        if (this.timeZone != null) {
            params.set((Object)"time_zone", (Object)this.timeZone);
        }
        if (this.lang != null) {
            params.set((Object)"lang", (Object)this.lang);
        }
        return params;
    }
}

