/*
 * Copyright 2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.social.twitter.api.impl;

import java.io.IOException;

import org.springframework.social.twitter.api.PlaceType;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

class PlaceTypeDeserializer extends JsonDeserializer<PlaceType> {

	@Override
	public PlaceType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
		String placeTypeText = jp.getText().toUpperCase();
		if(placeTypeText.equals("POI")) {
			return PlaceType.POINT_OF_INTEREST;
		}
		return PlaceType.valueOf(jp.getText().toUpperCase());
	}

}
