/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionKey;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.DuplicateConnectionException;
import org.springframework.social.connect.support.OAuth1ConnectionFactory;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.connect.web.ConnectInterceptor;
import org.springframework.social.connect.web.ConnectSupport;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"/connect"})
public class ConnectController {
    private static final Log logger = LogFactory.getLog(ConnectController.class);
    private final ConnectionFactoryLocator connectionFactoryLocator;
    private final ConnectionRepository connectionRepository;
    private final MultiValueMap<Class<?>, ConnectInterceptor<?>> interceptors = new LinkedMultiValueMap();
    private final ConnectSupport webSupport = new ConnectSupport();
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();
    private static final String DUPLICATE_CONNECTION_ATTRIBUTE = "social.addConnection.duplicate";

    @Inject
    public ConnectController(ConnectionFactoryLocator connectionFactoryLocator, ConnectionRepository connectionRepository) {
        this.connectionFactoryLocator = connectionFactoryLocator;
        this.connectionRepository = connectionRepository;
    }

    public void setInterceptors(List<ConnectInterceptor<?>> interceptors) {
        for (ConnectInterceptor<?> interceptor : interceptors) {
            this.addInterceptor(interceptor);
        }
    }

    public void setApplicationUrl(String applicationUrl) {
        this.webSupport.setApplicationUrl(applicationUrl);
    }

    public void addInterceptor(ConnectInterceptor<?> interceptor) {
        Class serviceApiType = GenericTypeResolver.resolveTypeArgument(interceptor.getClass(), ConnectInterceptor.class);
        this.interceptors.add((Object)serviceApiType, interceptor);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String connectionStatus(NativeWebRequest request, Model model) {
        this.setNoCache(request);
        this.processFlash((WebRequest)request, model);
        MultiValueMap connections = this.connectionRepository.findAllConnections();
        model.addAttribute("providerIds", (Object)this.connectionFactoryLocator.registeredProviderIds());
        model.addAttribute("connectionMap", (Object)connections);
        return this.connectView();
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.GET})
    public String connectionStatus(@PathVariable String providerId, NativeWebRequest request, Model model) {
        this.setNoCache(request);
        this.processFlash((WebRequest)request, model);
        List connections = this.connectionRepository.findConnections(providerId);
        if (connections.isEmpty()) {
            return this.connectView(providerId);
        }
        model.addAttribute("connections", (Object)connections);
        return this.connectedView(providerId);
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.POST})
    public RedirectView connect(@PathVariable String providerId, NativeWebRequest request) {
        ConnectionFactory connectionFactory = this.connectionFactoryLocator.getConnectionFactory(providerId);
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        this.preConnect(connectionFactory, (MultiValueMap<String, String>)parameters, (WebRequest)request);
        return new RedirectView(this.webSupport.buildOAuthUrl(connectionFactory, request, (MultiValueMap<String, String>)parameters));
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.GET}, params={"oauth_token"})
    public RedirectView oauth1Callback(@PathVariable String providerId, NativeWebRequest request) {
        OAuth1ConnectionFactory connectionFactory = (OAuth1ConnectionFactory)this.connectionFactoryLocator.getConnectionFactory(providerId);
        Connection<?> connection = this.webSupport.completeConnection(connectionFactory, request);
        this.addConnection(connection, (ConnectionFactory<?>)connectionFactory, (WebRequest)request);
        return this.connectionStatusRedirect(providerId, request);
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.GET}, params={"code"})
    public RedirectView oauth2Callback(@PathVariable String providerId, NativeWebRequest request) {
        try {
            OAuth2ConnectionFactory connectionFactory = (OAuth2ConnectionFactory)this.connectionFactoryLocator.getConnectionFactory(providerId);
            Connection<?> connection = this.webSupport.completeConnection(connectionFactory, request);
            this.addConnection(connection, (ConnectionFactory<?>)connectionFactory, (WebRequest)request);
        }
        catch (Exception e) {
            logger.warn((Object)("Exception while handling OAuth2 callback (" + e.getMessage() + "). Redirecting to " + providerId + " connection status page."));
        }
        return this.connectionStatusRedirect(providerId, request);
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.DELETE})
    public RedirectView removeConnections(@PathVariable String providerId, NativeWebRequest request) {
        this.connectionRepository.removeConnections(providerId);
        return this.connectionStatusRedirect(providerId, request);
    }

    @RequestMapping(value={"/{providerId}/{providerUserId}"}, method={RequestMethod.DELETE})
    public RedirectView removeConnection(@PathVariable String providerId, @PathVariable String providerUserId, NativeWebRequest request) {
        this.connectionRepository.removeConnection(new ConnectionKey(providerId, providerUserId));
        return this.connectionStatusRedirect(providerId, request);
    }

    protected String connectView() {
        return this.getViewPath() + "status";
    }

    protected String connectView(String providerId) {
        return this.getViewPath() + providerId + "Connect";
    }

    protected String connectedView(String providerId) {
        return this.getViewPath() + providerId + "Connected";
    }

    protected RedirectView connectionStatusRedirect(String providerId, NativeWebRequest request) {
        HttpServletRequest servletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        String path = "/connect/" + providerId + this.getPathExtension(servletRequest);
        if (this.prependServletPath(servletRequest)) {
            path = servletRequest.getServletPath() + path;
        }
        return new RedirectView(path, true);
    }

    private boolean prependServletPath(HttpServletRequest request) {
        return !this.urlPathHelper.getPathWithinServletMapping(request).equals("");
    }

    private String getPathExtension(HttpServletRequest request) {
        String fileName = WebUtils.extractFullFilenameFromUrlPath((String)request.getRequestURI());
        String extension = StringUtils.getFilenameExtension((String)fileName);
        return extension != null ? "." + extension : "";
    }

    private String getViewPath() {
        return "connect/";
    }

    private void addConnection(Connection<?> connection, ConnectionFactory<?> connectionFactory, WebRequest request) {
        try {
            this.connectionRepository.addConnection(connection);
            this.postConnect(connectionFactory, connection, request);
        }
        catch (DuplicateConnectionException e) {
            request.setAttribute(DUPLICATE_CONNECTION_ATTRIBUTE, (Object)e, 1);
        }
    }

    private void preConnect(ConnectionFactory<?> connectionFactory, MultiValueMap<String, String> parameters, WebRequest request) {
        for (ConnectInterceptor<?> interceptor : this.interceptingConnectionsTo(connectionFactory)) {
            interceptor.preConnect(connectionFactory, parameters, request);
        }
    }

    private void postConnect(ConnectionFactory<?> connectionFactory, Connection<?> connection, WebRequest request) {
        for (ConnectInterceptor<?> interceptor : this.interceptingConnectionsTo(connectionFactory)) {
            interceptor.postConnect(connection, request);
        }
    }

    private List<ConnectInterceptor<?>> interceptingConnectionsTo(ConnectionFactory<?> connectionFactory) {
        Class serviceType = GenericTypeResolver.resolveTypeArgument(connectionFactory.getClass(), ConnectionFactory.class);
        List<ConnectInterceptor<?>> typedInterceptors = (List<ConnectInterceptor<?>>)this.interceptors.get((Object)serviceType);
        if (typedInterceptors == null) {
            typedInterceptors = Collections.emptyList();
        }
        return typedInterceptors;
    }

    private void processFlash(WebRequest request, Model model) {
        DuplicateConnectionException exception = (DuplicateConnectionException)((Object)request.getAttribute(DUPLICATE_CONNECTION_ATTRIBUTE, 1));
        if (exception != null) {
            model.addAttribute(DUPLICATE_CONNECTION_ATTRIBUTE, (Object)Boolean.TRUE);
            request.removeAttribute(DUPLICATE_CONNECTION_ATTRIBUTE, 1);
        }
    }

    private void setNoCache(NativeWebRequest request) {
        HttpServletResponse response = (HttpServletResponse)request.getNativeResponse(HttpServletResponse.class);
        if (response != null) {
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 1L);
            response.setHeader("Cache-Control", "no-cache");
            response.addHeader("Cache-Control", "no-store");
        }
    }
}

