/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web;

import java.util.List;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.connect.support.OAuth1ConnectionFactory;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.connect.web.ConnectSupport;
import org.springframework.social.connect.web.ProviderSignInAttempt;
import org.springframework.social.connect.web.SignInAdapter;
import org.springframework.social.support.URIBuilder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.servlet.view.RedirectView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"/signin"})
public class ProviderSignInController {
    private static final Log logger = LogFactory.getLog(ProviderSignInController.class);
    private final ConnectionFactoryLocator connectionFactoryLocator;
    private final UsersConnectionRepository usersConnectionRepository;
    private final SignInAdapter signInAdapter;
    private String signInUrl = "/signin";
    private String signUpUrl = "/signup";
    private String postSignInUrl = "/";
    private final ConnectSupport webSupport = new ConnectSupport();

    @Inject
    public ProviderSignInController(ConnectionFactoryLocator connectionFactoryLocator, UsersConnectionRepository usersConnectionRepository, SignInAdapter signInAdapter) {
        this.connectionFactoryLocator = connectionFactoryLocator;
        this.usersConnectionRepository = usersConnectionRepository;
        this.signInAdapter = signInAdapter;
        this.webSupport.setUseAuthenticateUrl(true);
    }

    public void setSignInUrl(String signInUrl) {
        this.signInUrl = signInUrl;
    }

    public void setSignUpUrl(String signUpUrl) {
        this.signUpUrl = signUpUrl;
    }

    public void setPostSignInUrl(String postSignInUrl) {
        this.postSignInUrl = postSignInUrl;
    }

    public void setApplicationUrl(String applicationUrl) {
        this.webSupport.setApplicationUrl(applicationUrl);
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.POST})
    public RedirectView signIn(@PathVariable String providerId, NativeWebRequest request) {
        ConnectionFactory connectionFactory = this.connectionFactoryLocator.getConnectionFactory(providerId);
        try {
            return new RedirectView(this.webSupport.buildOAuthUrl(connectionFactory, request));
        }
        catch (Exception e) {
            return this.redirect(URIBuilder.fromUri((String)this.signInUrl).queryParam("error", "provider").build().toString());
        }
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.GET}, params={"oauth_token"})
    public RedirectView oauth1Callback(@PathVariable String providerId, NativeWebRequest request) {
        try {
            OAuth1ConnectionFactory connectionFactory = (OAuth1ConnectionFactory)this.connectionFactoryLocator.getConnectionFactory(providerId);
            Connection<?> connection = this.webSupport.completeConnection(connectionFactory, request);
            return this.handleSignIn(connection, request);
        }
        catch (Exception e) {
            return this.redirect(URIBuilder.fromUri((String)this.signInUrl).queryParam("error", "provider").build().toString());
        }
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.GET}, params={"code"})
    public RedirectView oauth2Callback(@PathVariable String providerId, @RequestParam(value="code") String code, NativeWebRequest request) {
        try {
            OAuth2ConnectionFactory connectionFactory = (OAuth2ConnectionFactory)this.connectionFactoryLocator.getConnectionFactory(providerId);
            Connection<?> connection = this.webSupport.completeConnection(connectionFactory, request);
            return this.handleSignIn(connection, request);
        }
        catch (Exception e) {
            logger.warn((Object)("Exception while handling OAuth2 callback (" + e.getMessage() + "). Redirecting to " + this.signInUrl));
            return this.redirect(URIBuilder.fromUri((String)this.signInUrl).queryParam("error", "provider").build().toString());
        }
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.GET})
    public RedirectView canceledAuthorizationCallback() {
        return this.redirect(this.signInUrl);
    }

    private RedirectView handleSignIn(Connection<?> connection, NativeWebRequest request) {
        List userIds = this.usersConnectionRepository.findUserIdsWithConnection(connection);
        if (userIds.size() == 0) {
            ProviderSignInAttempt signInAttempt = new ProviderSignInAttempt(connection, this.connectionFactoryLocator, this.usersConnectionRepository);
            request.setAttribute(ProviderSignInAttempt.SESSION_ATTRIBUTE, (Object)signInAttempt, 1);
            return this.redirect(this.signUpUrl);
        }
        if (userIds.size() == 1) {
            this.usersConnectionRepository.createConnectionRepository((String)userIds.get(0)).updateConnection(connection);
            String originalUrl = this.signInAdapter.signIn((String)userIds.get(0), connection, request);
            return originalUrl != null ? this.redirect(originalUrl) : this.redirect(this.postSignInUrl);
        }
        return this.redirect(URIBuilder.fromUri((String)this.signInUrl).queryParam("error", "multiple_users").build().toString());
    }

    private RedirectView redirect(String url) {
        return new RedirectView(url, true);
    }
}

