/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aopalliance.aop.AspectException;
import org.aspectj.weaver.tools.JoinPointMatch;
import org.aspectj.weaver.tools.PointcutExpression;
import org.aspectj.weaver.tools.PointcutParameter;
import org.aspectj.weaver.tools.PointcutParser;
import org.aspectj.weaver.tools.PointcutPrimitive;
import org.aspectj.weaver.tools.ShadowMatch;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.aop.support.AbstractExpressionPointcut;
import org.springframework.util.StringUtils;

public class AspectJExpressionPointcut
extends AbstractExpressionPointcut
implements ClassFilter,
MethodMatcher {
    private static final Set DEFAULT_SUPPORTED_PRIMITIVES = new HashSet();
    private final Map shadowMapCache = new HashMap();
    private PointcutParser pointcutParser;
    private Class pointcutDeclarationScope;
    private String[] pointcutParameterNames = new String[0];
    private Class[] pointcutParameterTypes = new Class[0];
    private PointcutExpression pointcutExpression;

    public AspectJExpressionPointcut() {
        this.pointcutParser = PointcutParser.getPointcutParserSupportingSpecifiedPrimitivesAndUsingContextClassloaderForResolution((Set)this.getSupportedPrimitives());
    }

    public AspectJExpressionPointcut(Class scope, String[] paramNames, Class[] paramTypes) {
        this();
        this.pointcutDeclarationScope = scope;
        if (paramNames.length != paramTypes.length) {
            throw new IllegalStateException("Number of pointcut parameter names must match number of pointcut parameter types");
        }
        this.pointcutParameterNames = paramNames;
        this.pointcutParameterTypes = paramTypes;
    }

    public ClassFilter getClassFilter() {
        this.checkReadyToMatch();
        return this;
    }

    public MethodMatcher getMethodMatcher() {
        this.checkReadyToMatch();
        return this;
    }

    public void onSetExpression(String expression) {
        PointcutParameter[] pointcutParameters = new PointcutParameter[this.pointcutParameterNames.length];
        for (int i = 0; i < pointcutParameters.length; ++i) {
            pointcutParameters[i] = this.pointcutParser.createPointcutParameter(this.pointcutParameterNames[i], this.pointcutParameterTypes[i]);
        }
        this.pointcutExpression = this.pointcutParser.parsePointcutExpression(this.replaceBooleanOperators(expression), this.pointcutDeclarationScope, pointcutParameters);
    }

    private String replaceBooleanOperators(String pcExpr) {
        pcExpr = StringUtils.replace((String)pcExpr, (String)" and ", (String)" && ");
        pcExpr = StringUtils.replace((String)pcExpr, (String)" or ", (String)" || ");
        pcExpr = StringUtils.replace((String)pcExpr, (String)" not ", (String)" ! ");
        return pcExpr;
    }

    public PointcutExpression getPointcutExpression() {
        return this.pointcutExpression;
    }

    protected Set getSupportedPrimitives() {
        return DEFAULT_SUPPORTED_PRIMITIVES;
    }

    private void checkReadyToMatch() {
        if (this.pointcutExpression == null) {
            throw new IllegalStateException("Must set property [expression] before attempting to match.");
        }
    }

    public boolean matches(Class targetClass) {
        this.checkReadyToMatch();
        return this.pointcutExpression.couldMatchJoinPointsInType(targetClass);
    }

    public boolean isRuntime() {
        this.checkReadyToMatch();
        return this.pointcutExpression.mayNeedDynamicTest();
    }

    public boolean matches(Method method, Class targetClass) {
        this.checkReadyToMatch();
        ShadowMatch shadowMatch = this.getShadowMatch(method);
        return shadowMatch.maybeMatches();
    }

    public boolean matches(Method method, Class targetClass, Object[] args) {
        Object target;
        ReflectiveMethodInvocation invocation;
        this.checkReadyToMatch();
        ShadowMatch shadowMatch = this.getShadowMatch(method);
        try {
            invocation = (ReflectiveMethodInvocation)ExposeInvocationInterceptor.currentInvocation();
            target = invocation.getThis();
        }
        catch (AspectException ex) {
            target = null;
            invocation = null;
        }
        JoinPointMatch joinPointMatch = shadowMatch.matchesJoinPoint(target, target, args);
        if (joinPointMatch.matches() && invocation != null) {
            this.bindParameters(invocation, joinPointMatch.getParameterBindings());
        }
        return joinPointMatch.matches();
    }

    public JoinPointMatch matchesWithBinding(Method method, Object targetObject, Object[] args) {
        ShadowMatch shadowMatch = this.pointcutExpression.matchesMethodExecution(method);
        return shadowMatch.matchesJoinPoint(targetObject, targetObject, args);
    }

    private void bindParameters(ReflectiveMethodInvocation invocation, PointcutParameter[] parameters) {
        Map bindingsMap = invocation.getUserAttributes();
        for (int i = 0; i < parameters.length; ++i) {
            PointcutParameter p = parameters[i];
            bindingsMap.put(p.getName(), p.getBinding());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShadowMatch getShadowMatch(Method method) {
        Map map = this.shadowMapCache;
        synchronized (map) {
            ShadowMatch shadowMatch = (ShadowMatch)this.shadowMapCache.get(method);
            if (shadowMatch == null) {
                shadowMatch = this.pointcutExpression.matchesMethodExecution(method);
                this.shadowMapCache.put(method, shadowMatch);
            }
            return shadowMatch;
        }
    }

    static {
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.EXECUTION);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.ARGS);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.REFERENCE);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.THIS);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.TARGET);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.WITHIN);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_ANNOTATION);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_WITHIN);
        DEFAULT_SUPPORTED_PRIMITIVES.add(PointcutPrimitive.AT_ARGS);
    }
}

