/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.io.Serializable;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;

public class ExposeJoinPointInterceptor
implements MethodInterceptor,
Serializable {
    public static final ExposeJoinPointInterceptor INSTANCE = new ExposeJoinPointInterceptor();
    private static ThreadLocal joinpointHolder = new ThreadLocal();

    public static JoinPoint currentJoinPoint() throws AspectException {
        return ExposeJoinPointInterceptor.currentProceedingJoinPoint();
    }

    public static ProceedingJoinPoint currentProceedingJoinPoint() throws AspectException {
        ProceedingJoinPoint jp = (ProceedingJoinPoint)joinpointHolder.get();
        if (jp == null) {
            throw new AspectException("No AspectJ JoinPoint found: check that an AOP invocation is in progress, and that the ExposeJoinPointInterceptor is in the interceptor chain");
        }
        return jp;
    }

    private ExposeJoinPointInterceptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation mi) throws Throwable {
        Object old = joinpointHolder.get();
        joinpointHolder.set(new MethodInvocationProceedingJoinPoint(mi));
        try {
            Object object = mi.proceed();
            return object;
        }
        finally {
            joinpointHolder.set(old);
        }
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

