/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aopalliance.aop.AspectException;
import org.aspectj.lang.annotation.DeclareParents;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.aop.Advisor;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.aspectj.AbstractAspectJAdvice;
import org.springframework.aop.aspectj.AspectInstanceFactory;
import org.springframework.aop.aspectj.AspectJAfterAdvice;
import org.springframework.aop.aspectj.AspectJAfterReturningAdvice;
import org.springframework.aop.aspectj.AspectJAfterThrowingAdvice;
import org.springframework.aop.aspectj.AspectJAroundAdvice;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.aspectj.AspectJMethodBeforeAdvice;
import org.springframework.aop.aspectj.annotation.AbstractAspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.InstantiationModelAwarePointcutAdvisor;
import org.springframework.aop.aspectj.annotation.LazySingletonMetadataAwareAspectInstanceFactoryDecorator;
import org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.support.ClassFilters;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.TypePatternClassFilter;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveAspectJAdvisorFactory
extends AbstractAspectJAdvisorFactory {
    @Override
    public List<Advisor> getAdvisors(MetadataAwareAspectInstanceFactory maaif) {
        Class<?> aspectClass = maaif.getAspectMetadata().getAspectClass();
        this.validate(aspectClass);
        final LazySingletonMetadataAwareAspectInstanceFactoryDecorator lazySingletonAspectInstanceFactory = new LazySingletonMetadataAwareAspectInstanceFactoryDecorator(maaif);
        final LinkedList<Advisor> advisors = new LinkedList<Advisor>();
        ReflectionUtils.doWithMethods(aspectClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method m) throws IllegalArgumentException, IllegalAccessException {
                InstantiationModelAwarePointcutAdvisor pa;
                if (m.getAnnotation(Pointcut.class) == null && (pa = ReflectiveAspectJAdvisorFactory.this.getAdvisor(m, lazySingletonAspectInstanceFactory)) != null) {
                    advisors.add(pa);
                }
            }
        });
        if (!advisors.isEmpty() && lazySingletonAspectInstanceFactory.getAspectMetadata().isPerThisOrPerTarget()) {
            SyntheticInstantiationAdvisor instantiationAdvisor = new SyntheticInstantiationAdvisor(lazySingletonAspectInstanceFactory);
            advisors.add(0, instantiationAdvisor);
        }
        for (Field f : aspectClass.getDeclaredFields()) {
            Advisor a;
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || (a = this.getDeclareParentsAdvisor(f)) == null) continue;
            advisors.add(a);
        }
        return advisors;
    }

    private Advisor getDeclareParentsAdvisor(Field introductionField) {
        DeclareParents declareParents = introductionField.getAnnotation(DeclareParents.class);
        if (declareParents == null) {
            return null;
        }
        final Class[] interfaces = new Class[]{introductionField.getType()};
        TypePatternClassFilter typePatternFilter = new TypePatternClassFilter(declareParents.value());
        ClassFilter exclusion = new ClassFilter(){

            public boolean matches(Class clazz) {
                for (Class introducedInterface : interfaces) {
                    if (!introducedInterface.isAssignableFrom(clazz)) continue;
                    return false;
                }
                return true;
            }
        };
        ClassFilter classFilter = ClassFilters.intersection(typePatternFilter, exclusion);
        try {
            Object meaninglessStaticDummyIntroductionInstanceUsedToDetermineConcreteClassWithNoArgConstructor = introductionField.get(null);
            Object newIntroductionInstanceToUse = meaninglessStaticDummyIntroductionInstanceUsedToDetermineConcreteClassWithNoArgConstructor.getClass().newInstance();
            return new AbstractAspectJAdvisorFactory.DelegatingIntroductionAdvisor(interfaces, classFilter, newIntroductionInstanceToUse);
        }
        catch (IllegalArgumentException ex) {
            throw new AspectException("Cannot evaluate static introduction field " + introductionField, ex);
        }
        catch (IllegalAccessException ex) {
            throw new AspectException("Cannot evaluate static introduction field " + introductionField, ex);
        }
        catch (InstantiationException ex) {
            throw new AspectException("Cannot instantiate class determined from static introduction field " + introductionField, ex);
        }
    }

    @Override
    public InstantiationModelAwarePointcutAdvisor getAdvisor(Method candidateAspectJAdviceMethod, MetadataAwareAspectInstanceFactory aif) {
        this.validate(aif.getAspectMetadata().getAspectClass());
        AspectJExpressionPointcut ajexp = this.getPointcut(candidateAspectJAdviceMethod, aif.getAspectMetadata().getAspectClass());
        if (ajexp == null) {
            return null;
        }
        return new InstantiationModelAwarePointcutAdvisor(this, ajexp, aif, candidateAspectJAdviceMethod);
    }

    @Override
    public Advice getAdvice(Method candidateAspectJAdviceMethod, MetadataAwareAspectInstanceFactory aif) {
        AbstractAspectJAdvice springAdvice;
        Class<?> candidateAspectClass = aif.getAspectMetadata().getAspectClass();
        this.validate(aif.getAspectMetadata().getAspectClass());
        AbstractAspectJAdvisorFactory.AspectJAnnotation aspectJAnnotation = AbstractAspectJAdvisorFactory.findAspectJAnnotationOnMethod(candidateAspectJAdviceMethod, candidateAspectClass);
        if (aspectJAnnotation == null) {
            return null;
        }
        if (!this.isAspect(candidateAspectClass)) {
            throw new AopConfigException("Advice must be declared inside an aspect type: Offending method '" + candidateAspectJAdviceMethod + "' in class " + candidateAspectClass.getName());
        }
        this.logger.debug((Object)("Found AspectJ method " + candidateAspectJAdviceMethod));
        AspectJExpressionPointcut ajexp = this.getPointcut(candidateAspectJAdviceMethod, candidateAspectClass);
        switch (aspectJAnnotation.getAnnotationType()) {
            case AtBefore: {
                springAdvice = new AspectJMethodBeforeAdvice(candidateAspectJAdviceMethod, ajexp.getPointcutExpression(), (AspectInstanceFactory)aif);
                break;
            }
            case AtAfter: {
                springAdvice = new AspectJAfterAdvice(candidateAspectJAdviceMethod, ajexp.getPointcutExpression(), (AspectInstanceFactory)aif);
                break;
            }
            case AtAfterReturning: {
                springAdvice = new AspectJAfterReturningAdvice(candidateAspectJAdviceMethod, ajexp.getPointcutExpression(), (AspectInstanceFactory)aif);
                break;
            }
            case AtAfterThrowing: {
                springAdvice = new AspectJAfterThrowingAdvice(candidateAspectJAdviceMethod, ajexp.getPointcutExpression(), (AspectInstanceFactory)aif);
                break;
            }
            case AtAround: {
                springAdvice = new AspectJAroundAdvice(candidateAspectJAdviceMethod, ajexp.getPointcutExpression(), (AspectInstanceFactory)aif, this.parameterNameDiscoverer);
                break;
            }
            case AtPointcut: {
                this.logger.debug((Object)("Processing pointcut '" + candidateAspectJAdviceMethod.getName() + "'"));
                return null;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported advice type on method " + candidateAspectJAdviceMethod);
            }
        }
        return springAdvice;
    }

    private AspectJExpressionPointcut getPointcut(Method candidateAspectJAdviceMethod, Class<?> candidateAspectClass) {
        AbstractAspectJAdvisorFactory.AspectJAnnotation aspectJAnnotation = AbstractAspectJAdvisorFactory.findAspectJAnnotationOnMethod(candidateAspectJAdviceMethod, candidateAspectClass);
        if (aspectJAnnotation == null) {
            return null;
        }
        String[] argNames = this.parameterNameDiscoverer.getParameterNames(candidateAspectJAdviceMethod, candidateAspectClass);
        AspectJExpressionPointcut ajexp = this.createPointcutExpression(candidateAspectJAdviceMethod, candidateAspectClass, argNames);
        ajexp.setExpression(aspectJAnnotation.getPointcutExpression());
        return ajexp;
    }

    protected static class SyntheticInstantiationAdvisor
    extends DefaultPointcutAdvisor {
        public SyntheticInstantiationAdvisor(final MetadataAwareAspectInstanceFactory aif) {
            super(aif.getAspectMetadata().getPerClausePointcut(), new MethodBeforeAdvice(){

                public void before(Method method, Object[] args, Object target) {
                    aif.getAspectInstance();
                }
            });
        }
    }
}

