/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.config;

import java.util.List;
import org.springframework.aop.config.NamespaceHandlerUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AopNamespaceHandler
extends NamespaceHandlerSupport {
    static /* synthetic */ Class class$org$springframework$aop$target$scope$ScopedProxyFactoryBean;
    static /* synthetic */ Class class$org$springframework$aop$support$DefaultPointcutAdvisor;
    static /* synthetic */ Class class$org$springframework$aop$config$MethodLocatingFactoryBean;
    static /* synthetic */ Class class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory;
    static /* synthetic */ Class class$org$springframework$core$PrioritizedParameterNameDiscoverer;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAfterAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAroundAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJExpressionPointcut;

    public AopNamespaceHandler() {
        this.registerBeanDefinitionParser("config", new ConfigBeanDefinitionParser());
        this.registerBeanDefinitionParser("spring-configured", new SpringConfiguredBeanDefinitionParser());
        this.registerBeanDefinitionParser("aspectj-autoproxy", new AspectJAutoProxyBeanDefinitionParser());
        this.registerBeanDefinitionDecorator("scope", new ScopeBeanDefinitionDefinition());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ConfigBeanDefinitionParser
    implements BeanDefinitionParser {
        private static final String ASPECT = "aspect";
        private static final String EXPRESSION = "expression";
        private static final String ID = "id";
        private static final String POINTCUT = "pointcut";
        private static final String ADVICE = "advice";
        private static final String ADVISOR = "advisor";
        private static final String ADVICE_REF = "advice-ref";
        private static final String POINTCUT_REF = "pointcut-ref";
        private static final String REF = "ref";
        private static final String KIND = "kind";
        private static final String BEFORE = "before";
        private static final String AFTER = "after";
        private static final String AFTER_RETURNING = "afterReturning";
        private static final String AFTER_THROWING = "afterThrowing";
        private static final String AROUND = "around";
        private static final String PROXY_TARGET_CLASS = "proxyTargetClass";
        private static final String TRUE = "true";
        private static final int METHOD_INDEX = 0;
        private static final int POINTCUT_INDEX = 1;
        private static final int ASPECT_INSTANCE_FACTORY_INDEX = 2;
        private static final int PARAMETER_NAME_DISCOVERER = 3;

        private ConfigBeanDefinitionParser() {
        }

        public void parse(Element element, BeanDefinitionRegistry registry) {
            NodeList childNodes = element.getChildNodes();
            NamespaceHandlerUtils.registerAutoProxyCreatorIfNecessary(registry);
            boolean proxyTargetClass = TRUE.equals(element.getAttribute(PROXY_TARGET_CLASS));
            if (proxyTargetClass) {
                NamespaceHandlerUtils.forceAutoProxyCreatorToUseClassProxying(registry);
            }
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (node.getNodeType() != 1) continue;
                String localName = node.getLocalName();
                if (POINTCUT.equals(localName)) {
                    this.parsePointcut((Element)node, registry);
                    continue;
                }
                if (ADVISOR.equals(localName)) {
                    this.parseAdvisor((Element)node, registry);
                    continue;
                }
                if (!ASPECT.equals(localName)) continue;
                this.parseAspect((Element)node, registry);
            }
        }

        private void parsePointcut(Element pointcutElement, BeanDefinitionRegistry registry) {
            BeanDefinition pointcutDefinition = this.createPointcutDefinition(pointcutElement.getAttribute(EXPRESSION));
            String id = pointcutElement.getAttribute(ID);
            if (!StringUtils.hasText((String)id)) {
                id = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)((AbstractBeanDefinition)pointcutDefinition), (BeanDefinitionRegistry)registry, (boolean)false);
            }
            registry.registerBeanDefinition(id, pointcutDefinition);
        }

        private void parseAdvisor(Element element, BeanDefinitionRegistry registry) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(class$org$springframework$aop$support$DefaultPointcutAdvisor == null ? (class$org$springframework$aop$support$DefaultPointcutAdvisor = AopNamespaceHandler.class$("org.springframework.aop.support.DefaultPointcutAdvisor")) : class$org$springframework$aop$support$DefaultPointcutAdvisor);
            MutablePropertyValues mpvs = new MutablePropertyValues();
            beanDefinition.setPropertyValues(mpvs);
            mpvs.addPropertyValue(ADVICE, (Object)new RuntimeBeanReference(element.getAttribute(ADVICE_REF)));
            this.parsePointcutProperty(element, mpvs, registry);
            String id = element.getAttribute(ID);
            if (!StringUtils.hasText((String)id)) {
                id = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry, (boolean)false);
            }
            registry.registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        }

        private void parseAspect(Element aspectElement, BeanDefinitionRegistry registry) {
            String aspectName = aspectElement.getAttribute(REF);
            List pointcuts = DomUtils.getChildElementsByTagName((Element)aspectElement, (String)POINTCUT, (boolean)true);
            for (int i = 0; i < pointcuts.size(); ++i) {
                Element pointcutElement = (Element)pointcuts.get(i);
                this.parsePointcut(pointcutElement, registry);
            }
            List advice = DomUtils.getChildElementsByTagName((Element)aspectElement, (String)ADVICE, (boolean)true);
            for (int i = 0; i < advice.size(); ++i) {
                Element adviceElement = (Element)advice.get(i);
                this.parseAdvice(aspectName, adviceElement, registry);
            }
        }

        private void parseAdvice(String aspectName, Element adviceElement, BeanDefinitionRegistry registry) {
            MutablePropertyValues advisorProperties = new MutablePropertyValues();
            String pointcutBeanName = this.parsePointcutProperty(adviceElement, advisorProperties, registry);
            RootBeanDefinition methodDefinition = new RootBeanDefinition(class$org$springframework$aop$config$MethodLocatingFactoryBean == null ? (class$org$springframework$aop$config$MethodLocatingFactoryBean = AopNamespaceHandler.class$("org.springframework.aop.config.MethodLocatingFactoryBean")) : class$org$springframework$aop$config$MethodLocatingFactoryBean);
            methodDefinition.setPropertyValues(new MutablePropertyValues());
            methodDefinition.getPropertyValues().addPropertyValue("targetBeanName", (Object)aspectName);
            methodDefinition.getPropertyValues().addPropertyValue("methodName", (Object)adviceElement.getAttribute("method"));
            RootBeanDefinition instanceFactoryDefinition = new RootBeanDefinition(class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory == null ? (class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory = AopNamespaceHandler.class$("org.springframework.aop.config.BeanFactoryAspectInstanceFactory")) : class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory);
            instanceFactoryDefinition.setPropertyValues(new MutablePropertyValues());
            instanceFactoryDefinition.getPropertyValues().addPropertyValue("aspectBeanName", (Object)aspectName);
            String kind = adviceElement.getAttribute(KIND);
            RootBeanDefinition adviceDefinition = new RootBeanDefinition(this.getAdviceClass(kind));
            ConstructorArgumentValues cav = new ConstructorArgumentValues();
            cav.addIndexedArgumentValue(0, (Object)methodDefinition);
            cav.addIndexedArgumentValue(1, (Object)new RuntimeBeanReference(pointcutBeanName));
            cav.addIndexedArgumentValue(2, (Object)instanceFactoryDefinition);
            this.extendAdviceConstructorArgs(cav, kind);
            adviceDefinition.setConstructorArgumentValues(cav);
            RootBeanDefinition advisorDefinition = new RootBeanDefinition(class$org$springframework$aop$support$DefaultPointcutAdvisor == null ? (class$org$springframework$aop$support$DefaultPointcutAdvisor = AopNamespaceHandler.class$("org.springframework.aop.support.DefaultPointcutAdvisor")) : class$org$springframework$aop$support$DefaultPointcutAdvisor);
            advisorDefinition.setPropertyValues(advisorProperties);
            advisorDefinition.getPropertyValues().addPropertyValue(ADVICE, (Object)adviceDefinition);
            String id = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)advisorDefinition, (BeanDefinitionRegistry)registry, (boolean)false);
            registry.registerBeanDefinition(id, (BeanDefinition)advisorDefinition);
        }

        private void extendAdviceConstructorArgs(ConstructorArgumentValues cav, String kind) {
            if (AROUND.equals(kind)) {
                RootBeanDefinition discovererDefinition = new RootBeanDefinition(class$org$springframework$core$PrioritizedParameterNameDiscoverer == null ? (class$org$springframework$core$PrioritizedParameterNameDiscoverer = AopNamespaceHandler.class$("org.springframework.core.PrioritizedParameterNameDiscoverer")) : class$org$springframework$core$PrioritizedParameterNameDiscoverer);
                cav.addIndexedArgumentValue(3, (Object)discovererDefinition);
            }
        }

        private Class getAdviceClass(String kind) {
            if (BEFORE.equals(kind)) {
                return class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice == null ? (class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice = AopNamespaceHandler.class$("org.springframework.aop.aspectj.AspectJMethodBeforeAdvice")) : class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice;
            }
            if (AFTER.equals(kind)) {
                return class$org$springframework$aop$aspectj$AspectJAfterAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterAdvice = AopNamespaceHandler.class$("org.springframework.aop.aspectj.AspectJAfterAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterAdvice;
            }
            if (AFTER_RETURNING.equals(kind)) {
                return class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice = AopNamespaceHandler.class$("org.springframework.aop.aspectj.AspectJAfterReturningAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice;
            }
            if (AFTER_THROWING.equals(kind)) {
                return class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice = AopNamespaceHandler.class$("org.springframework.aop.aspectj.AspectJAfterThrowingAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice;
            }
            if (AROUND.equals(kind)) {
                return class$org$springframework$aop$aspectj$AspectJAroundAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAroundAdvice = AopNamespaceHandler.class$("org.springframework.aop.aspectj.AspectJAroundAdvice")) : class$org$springframework$aop$aspectj$AspectJAroundAdvice;
            }
            throw new IllegalArgumentException("Unknown advice kind [" + kind + "].");
        }

        private String parsePointcutProperty(Element element, MutablePropertyValues mpvs, BeanDefinitionRegistry registry) {
            if (element.hasAttribute(POINTCUT) && element.hasAttribute(POINTCUT_REF)) {
                throw new IllegalStateException("Cannot define both 'pointcut' and 'pointcut-ref' on 'advisor' tag.");
            }
            if (element.hasAttribute(POINTCUT)) {
                BeanDefinition pointcutDefinition = this.createPointcutDefinition(element.getAttribute(POINTCUT));
                String pointcutName = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)((AbstractBeanDefinition)pointcutDefinition), (BeanDefinitionRegistry)registry, (boolean)false);
                registry.registerBeanDefinition(pointcutName, pointcutDefinition);
                mpvs.addPropertyValue(POINTCUT, (Object)new RuntimeBeanReference(pointcutName));
                return pointcutName;
            }
            if (element.hasAttribute(POINTCUT_REF)) {
                String pointcutRef = element.getAttribute(POINTCUT_REF);
                mpvs.addPropertyValue(POINTCUT, (Object)new RuntimeBeanReference(pointcutRef));
                return pointcutRef;
            }
            throw new IllegalStateException("Must define one of 'pointcut' or 'pointcut-ref' on 'advisor'.");
        }

        protected BeanDefinition createPointcutDefinition(String expression) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition();
            beanDefinition.setBeanClass(class$org$springframework$aop$aspectj$AspectJExpressionPointcut == null ? (class$org$springframework$aop$aspectj$AspectJExpressionPointcut = AopNamespaceHandler.class$("org.springframework.aop.aspectj.AspectJExpressionPointcut")) : class$org$springframework$aop$aspectj$AspectJExpressionPointcut);
            beanDefinition.setPropertyValues(new MutablePropertyValues());
            beanDefinition.getPropertyValues().addPropertyValue(EXPRESSION, (Object)expression);
            return beanDefinition;
        }
    }

    private static class AspectJAutoProxyBeanDefinitionParser
    implements BeanDefinitionParser {
        private AspectJAutoProxyBeanDefinitionParser() {
        }

        public void parse(Element element, BeanDefinitionRegistry registry) {
            NamespaceHandlerUtils.registerAspectJAutoProxyCreatorIfNecessary(registry);
        }
    }

    private static class SpringConfiguredBeanDefinitionParser
    implements BeanDefinitionParser {
        private static final String BEAN_CONFIGURER = "org.springframework.beans.factory.aspectj.AnnotationBeanConfigurer";
        private boolean registered;

        private SpringConfiguredBeanDefinitionParser() {
        }

        public void parse(Element element, BeanDefinitionRegistry registry) {
            if (this.registered) {
                return;
            }
            try {
                Class beanConfigurerClass = ClassUtils.forName((String)BEAN_CONFIGURER);
                RootBeanDefinition definition = new RootBeanDefinition(beanConfigurerClass);
                definition.setFactoryMethodName("aspectOf");
                String id = BeanDefinitionReaderUtils.generateBeanName((AbstractBeanDefinition)definition, (BeanDefinitionRegistry)registry, (boolean)false);
                registry.registerBeanDefinition(id, (BeanDefinition)definition);
                this.registered = true;
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Unable to locate class [org.springframework.beans.factory.aspectj.AnnotationBeanConfigurer]: cannot use @Configurable");
            }
        }
    }

    private static class ScopeBeanDefinitionDefinition
    implements BeanDefinitionDecorator {
        private static String REQUEST_SCOPE_MAP = "org.springframework.web.context.scope.RequestScopeMap";
        private static String SESSION_SCOPE_MAP = "org.springframework.web.context.scope.SessionScopeMap";

        private ScopeBeanDefinitionDefinition() {
        }

        public BeanDefinitionHolder decorate(Element element, BeanDefinitionHolder definition, BeanDefinitionRegistry registry) {
            Class scopeMapClass;
            String scopeMapClassName;
            NamespaceHandlerUtils.forceAutoProxyCreatorToUseClassProxying(registry);
            String originalBeanName = definition.getBeanName();
            String targetBeanName = "__" + originalBeanName;
            RootBeanDefinition scopeFactoryDefinition = new RootBeanDefinition(class$org$springframework$aop$target$scope$ScopedProxyFactoryBean == null ? (class$org$springframework$aop$target$scope$ScopedProxyFactoryBean = AopNamespaceHandler.class$("org.springframework.aop.target.scope.ScopedProxyFactoryBean")) : class$org$springframework$aop$target$scope$ScopedProxyFactoryBean);
            MutablePropertyValues mpvs = new MutablePropertyValues();
            scopeFactoryDefinition.setPropertyValues(mpvs);
            mpvs.addPropertyValue("targetBeanName", (Object)targetBeanName);
            mpvs.addPropertyValue("scopeKey", (Object)originalBeanName);
            String type = element.getAttribute("type");
            if ("request".equals(type)) {
                scopeMapClassName = REQUEST_SCOPE_MAP;
            } else if ("session".equals(type)) {
                scopeMapClassName = SESSION_SCOPE_MAP;
            } else {
                throw new IllegalStateException("Scope [" + type + "] is not recognised.");
            }
            try {
                scopeMapClass = ClassUtils.forName((String)scopeMapClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Unable to locate ScopeMap class [" + scopeMapClassName + "].");
            }
            mpvs.addPropertyValue("scopeMap", (Object)new RootBeanDefinition(scopeMapClass));
            registry.registerBeanDefinition(originalBeanName, (BeanDefinition)scopeFactoryDefinition);
            ((AbstractBeanDefinition)definition.getBeanDefinition()).setSingleton(false);
            return new BeanDefinitionHolder(definition.getBeanDefinition(), targetBeanName);
        }
    }
}

