/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.scope;

import org.springframework.aop.scope.ScopedObject;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.util.Assert;

public class DefaultScopedObject
implements ScopedObject {
    private final ConfigurableBeanFactory beanFactory;
    private final String targetBeanName;

    public DefaultScopedObject(ConfigurableBeanFactory beanFactory, String targetBeanName) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        Assert.hasText((String)targetBeanName, (String)"Target bean name must not be null or consist wholly of whitespace");
        this.beanFactory = beanFactory;
        this.targetBeanName = targetBeanName;
    }

    public Object getTargetObject() {
        return this.beanFactory.getBean(this.targetBeanName);
    }

    public void removeFromScope() {
        this.beanFactory.destroyScopedBean(this.targetBeanName);
    }
}

