/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.aop.target.AbstractPoolingTargetSource;

public class CommonsPool2TargetSource
extends AbstractPoolingTargetSource
implements PooledObjectFactory<Object> {
    private int maxIdle = 8;
    private int minIdle = 0;
    private long maxWait = 8L;
    private long timeBetweenEvictionRunsMillis = -1L;
    private long minEvictableIdleTimeMillis = 1800000L;
    private boolean blockWhenExhausted = true;
    private boolean useObjectEquality;
    private ObjectPool pool;

    public CommonsPool2TargetSource() {
        this.setMaxSize(8);
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setBlockWhenExhausted(boolean blockWhenExhausted) {
        this.blockWhenExhausted = blockWhenExhausted;
    }

    public boolean isBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    public void setUseObjectEquality(boolean useObjectEquality) {
        this.useObjectEquality = useObjectEquality;
    }

    public boolean isUseObjectEquality() {
        return this.useObjectEquality;
    }

    @Override
    protected final void createPool() {
        this.logger.debug((Object)"Creating Commons object pool");
        this.pool = this.createObjectPool();
    }

    protected ObjectPool createObjectPool() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(this.getMaxSize());
        config.setMaxIdle(this.getMaxIdle());
        config.setMinIdle(this.getMinIdle());
        config.setMaxWaitMillis(this.getMaxWait());
        config.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
        config.setMinEvictableIdleTimeMillis(this.getMinEvictableIdleTimeMillis());
        config.setBlockWhenExhausted(this.isBlockWhenExhausted());
        return new GenericObjectPool((PooledObjectFactory)this, config);
    }

    @Override
    public Object getTarget() throws Exception {
        Object o = this.pool.borrowObject();
        return this.isUseObjectEquality() ? o : ((IdentityWrapper)o).target;
    }

    @Override
    public void releaseTarget(Object target) throws Exception {
        Object value = this.isUseObjectEquality() ? target : new IdentityWrapper(target);
        this.pool.returnObject(value);
    }

    @Override
    public int getActiveCount() throws UnsupportedOperationException {
        return this.pool.getNumActive();
    }

    @Override
    public int getIdleCount() throws UnsupportedOperationException {
        return this.pool.getNumIdle();
    }

    public void destroy() throws Exception {
        this.logger.debug((Object)"Closing Commons ObjectPool");
        this.pool.close();
    }

    public PooledObject<Object> makeObject() throws Exception {
        Object target = this.newPrototypeInstance();
        Object poolValue = this.isUseObjectEquality() ? target : new IdentityWrapper(target);
        return new DefaultPooledObject(poolValue);
    }

    public void destroyObject(PooledObject<Object> p) throws Exception {
        this.destroyPrototypeInstance(p.getObject());
    }

    public boolean validateObject(PooledObject<Object> p) {
        return true;
    }

    public void activateObject(PooledObject<Object> p) throws Exception {
    }

    public void passivateObject(PooledObject<Object> p) throws Exception {
    }

    private static class IdentityWrapper {
        private final Object target;

        public IdentityWrapper(Object target) {
            this.target = target;
        }

        public int hashCode() {
            return System.identityHashCode(this.target);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdentityWrapper that = (IdentityWrapper)o;
            return !(this.target == null ? that.target != null : this.target != that.target);
        }
    }
}

