/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ObjectUtils;

public class BeanDefinitionBuilder {
    private AbstractBeanDefinition beanDefinition;
    private int constructorArgIndex;
    private String assignedBeanName;

    public static BeanDefinitionBuilder rootBeanDefinition(Class beanClass) {
        return BeanDefinitionBuilder.rootBeanDefinition(beanClass, null);
    }

    public static BeanDefinitionBuilder rootBeanDefinition(Class beanClass, String factoryMethod) {
        BeanDefinitionBuilder builder = new BeanDefinitionBuilder();
        builder.beanDefinition = new RootBeanDefinition();
        builder.beanDefinition.setBeanClass(beanClass);
        builder.beanDefinition.setFactoryMethodName(factoryMethod);
        return builder;
    }

    public static BeanDefinitionBuilder childBeanDefinition(String parentBeanName) {
        BeanDefinitionBuilder builder = new BeanDefinitionBuilder();
        builder.beanDefinition = new ChildBeanDefinition(parentBeanName);
        return builder;
    }

    protected BeanDefinitionBuilder() {
    }

    public AbstractBeanDefinition getBeanDefinition() {
        this.beanDefinition.validate();
        return this.beanDefinition;
    }

    public BeanDefinitionBuilder addPropertyValue(String name, Object value) {
        if (this.beanDefinition.getPropertyValues() == null) {
            this.beanDefinition.setPropertyValues(new MutablePropertyValues());
        }
        this.beanDefinition.getPropertyValues().addPropertyValue(new PropertyValue(name, value));
        return this;
    }

    public BeanDefinitionBuilder addPropertyReference(String name, String bean) {
        return this.addPropertyValue(name, new RuntimeBeanReference(bean));
    }

    public BeanDefinitionBuilder addPropertyReference(String name, BeanDefinitionBuilder target) {
        return this.addPropertyReference(name, this.getTargetBeanName(target));
    }

    public BeanDefinitionBuilder addConstructorArg(Object value) {
        if (this.beanDefinition.getConstructorArgumentValues() == null) {
            this.beanDefinition.setConstructorArgumentValues(new ConstructorArgumentValues());
        }
        this.beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(this.constructorArgIndex++, value);
        return this;
    }

    public BeanDefinitionBuilder addConstructorArgReference(String beanName) {
        return this.addConstructorArg(new RuntimeBeanReference(beanName));
    }

    public BeanDefinitionBuilder addConstructorArgReference(BeanDefinitionBuilder target) {
        return this.addConstructorArgReference(this.getTargetBeanName(target));
    }

    public BeanDefinitionBuilder setFactoryMethod(String factoryMethod) {
        this.beanDefinition.setFactoryMethodName(factoryMethod);
        return this;
    }

    public BeanDefinitionBuilder setFactoryBean(String factoryBean, String factoryMethod) {
        this.beanDefinition.setFactoryBeanName(factoryBean);
        this.beanDefinition.setFactoryMethodName(factoryMethod);
        return this;
    }

    public BeanDefinitionBuilder setSingleton(boolean singleton) {
        this.beanDefinition.setSingleton(singleton);
        return this;
    }

    public BeanDefinitionBuilder setAbstract(boolean flag) {
        this.beanDefinition.setAbstract(flag);
        return this;
    }

    public BeanDefinitionBuilder setLazyInit(boolean lazy) {
        this.beanDefinition.setLazyInit(lazy);
        return this;
    }

    public BeanDefinitionBuilder setAutowireMode(int autowireMode) {
        this.beanDefinition.setAutowireMode(autowireMode);
        return this;
    }

    public BeanDefinitionBuilder setDependencyCheck(int dependencyCheck) {
        this.beanDefinition.setDependencyCheck(dependencyCheck);
        return this;
    }

    public BeanDefinitionBuilder setDestroyMethodName(String methodName) {
        this.beanDefinition.setDestroyMethodName(methodName);
        return this;
    }

    public BeanDefinitionBuilder setInitMethodName(String methodName) {
        this.beanDefinition.setInitMethodName(methodName);
        return this;
    }

    public BeanDefinitionBuilder setResourceDescription(String resourceDescription) {
        this.beanDefinition.setResourceDescription(resourceDescription);
        return this;
    }

    public BeanDefinitionBuilder addDependsOn(String beanName) {
        if (this.beanDefinition.getDependsOn() == null) {
            this.beanDefinition.setDependsOn(new String[]{beanName});
        } else {
            String[] added = (String[])ObjectUtils.addObjectToArray((Object[])this.beanDefinition.getDependsOn(), (Object)beanName);
            this.beanDefinition.setDependsOn(added);
        }
        return this;
    }

    protected void assignBeanName(String name) {
        if (this.assignedBeanName != null) {
            throw new IllegalStateException("Cannot assign bean name: bean name of '" + this.assignedBeanName + "' already assigned");
        }
        this.assignedBeanName = name;
    }

    private String getTargetBeanName(BeanDefinitionBuilder target) throws IllegalArgumentException {
        String assignedBeanName = target.assignedBeanName;
        if (assignedBeanName == null) {
            throw new IllegalArgumentException("Cannot add a reference to the bean identified by the supplied BeanDefinitonBuilder. No bean name has been assigned.");
        }
        return assignedBeanName;
    }
}

