/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.core.CollectionFactory;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.JdkVersion;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class TypeConverterDelegate {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$TypeConverterDelegate == null ? (class$org$springframework$beans$TypeConverterDelegate = TypeConverterDelegate.class$("org.springframework.beans.TypeConverterDelegate")) : class$org$springframework$beans$TypeConverterDelegate));
    private final PropertyEditorRegistrySupport propertyEditorRegistry;
    private final Object targetObject;
    static /* synthetic */ Class class$org$springframework$beans$TypeConverterDelegate;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    public TypeConverterDelegate(PropertyEditorRegistrySupport propertyEditorRegistry) {
        this(propertyEditorRegistry, null);
    }

    public TypeConverterDelegate(PropertyEditorRegistrySupport propertyEditorRegistry, Object targetObject) {
        Assert.notNull((Object)propertyEditorRegistry, (String)"Property editor registry must not be null");
        this.propertyEditorRegistry = propertyEditorRegistry;
        this.targetObject = targetObject;
    }

    public Object convertIfNecessary(Object newValue, Class requiredType) throws IllegalArgumentException {
        return this.convertIfNecessary(null, null, newValue, requiredType, null, null);
    }

    public Object convertIfNecessary(Object newValue, Class requiredType, MethodParameter methodParam) throws IllegalArgumentException {
        return this.convertIfNecessary(null, null, newValue, requiredType, null, methodParam);
    }

    public Object convertIfNecessary(String propertyName, Object oldValue, Object newValue, Class requiredType) throws IllegalArgumentException {
        return this.convertIfNecessary(propertyName, oldValue, newValue, requiredType, null, null);
    }

    public Object convertIfNecessary(Object oldValue, Object newValue, PropertyDescriptor descriptor) throws IllegalArgumentException {
        Assert.notNull((Object)descriptor, (String)"PropertyDescriptor must not be null");
        return this.convertIfNecessary(descriptor.getName(), oldValue, newValue, descriptor.getPropertyType(), descriptor, new MethodParameter(descriptor.getWriteMethod(), 0));
    }

    protected Object convertIfNecessary(String propertyName, Object oldValue, Object newValue, Class requiredType, PropertyDescriptor descriptor, MethodParameter methodParam) throws IllegalArgumentException {
        Object convertedValue = newValue;
        PropertyEditor pe = this.propertyEditorRegistry.findCustomEditor(requiredType, propertyName);
        if (pe != null || requiredType != null && !ClassUtils.isAssignableValue((Class)requiredType, (Object)convertedValue)) {
            if (pe == null && descriptor != null) {
                if (JdkVersion.isAtLeastJava15()) {
                    pe = descriptor.createPropertyEditor(this.targetObject);
                } else {
                    Class<?> editorClass = descriptor.getPropertyEditorClass();
                    if (editorClass != null) {
                        pe = (PropertyEditor)BeanUtils.instantiateClass(editorClass);
                    }
                }
            }
            if (pe == null && requiredType != null && (pe = this.propertyEditorRegistry.getDefaultEditor(requiredType)) == null) {
                pe = PropertyEditorManager.findEditor(requiredType);
            }
            convertedValue = this.convertValue(convertedValue, requiredType, pe, oldValue);
        }
        if (requiredType != null) {
            block14: {
                if (convertedValue != null && requiredType.isArray()) {
                    return this.convertToTypedArray(convertedValue, propertyName, requiredType.getComponentType());
                }
                if (convertedValue instanceof Collection && (class$java$util$Collection == null ? (class$java$util$Collection = TypeConverterDelegate.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(requiredType)) {
                    return this.convertToTypedCollection((Collection)convertedValue, propertyName, methodParam);
                }
                if (convertedValue instanceof Map && (class$java$util$Map == null ? (class$java$util$Map = TypeConverterDelegate.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(requiredType)) {
                    return this.convertToTypedMap((Map)convertedValue, propertyName, methodParam);
                }
                if (convertedValue instanceof String && !requiredType.isInstance(convertedValue)) {
                    try {
                        Field enumField = requiredType.getField((String)convertedValue);
                        convertedValue = enumField.get(null);
                    }
                    catch (Throwable ex) {
                        if (!logger.isTraceEnabled()) break block14;
                        logger.trace((Object)("Field [" + convertedValue + "] isn't an enum value"), ex);
                    }
                }
            }
            if (!ClassUtils.isAssignableValue((Class)requiredType, (Object)convertedValue)) {
                throw new IllegalArgumentException("Cannot convert value of type [" + (newValue != null ? ClassUtils.getQualifiedName(newValue.getClass()) : null) + "] to required type [" + ClassUtils.getQualifiedName((Class)requiredType) + "] for property '" + propertyName + "': no matching editors or conversion strategy found");
            }
        }
        return convertedValue;
    }

    protected Object convertValue(Object newValue, Class requiredType, PropertyEditor pe, Object oldValue) {
        Object convertedValue = newValue;
        if (pe != null && !(convertedValue instanceof String)) {
            pe.setValue(convertedValue);
            Object newConvertedValue = pe.getValue();
            if (newConvertedValue != convertedValue) {
                convertedValue = newConvertedValue;
                pe = null;
            }
        }
        if (requiredType != null && !requiredType.isArray() && convertedValue instanceof String[]) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Converting String array to comma-delimited String [" + convertedValue + "]"));
            }
            convertedValue = StringUtils.arrayToCommaDelimitedString((Object[])((String[])convertedValue));
        }
        if (pe != null && convertedValue instanceof String) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Converting String to [" + requiredType + "] using property editor [" + pe + "]"));
            }
            pe.setValue(oldValue);
            pe.setAsText((String)convertedValue);
            convertedValue = pe.getValue();
        }
        return convertedValue;
    }

    protected Object convertToTypedArray(Object input, String propertyName, Class componentType) {
        if (input instanceof Collection) {
            Collection coll = (Collection)input;
            Object result = Array.newInstance(componentType, coll.size());
            int i = 0;
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                Object value = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, i), null, it.next(), componentType);
                Array.set(result, i, value);
                ++i;
            }
            return result;
        }
        if (input.getClass().isArray()) {
            if (componentType.equals(input.getClass().getComponentType()) && !this.propertyEditorRegistry.hasCustomEditorForElement(componentType, propertyName)) {
                return input;
            }
            int arrayLength = Array.getLength(input);
            Object result = Array.newInstance(componentType, arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                Object value = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, i), null, Array.get(input, i), componentType);
                Array.set(result, i, value);
            }
            return result;
        }
        Object result = Array.newInstance(componentType, 1);
        Object value = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, 0), null, input, componentType);
        Array.set(result, 0, value);
        return result;
    }

    protected Collection convertToTypedCollection(Collection original, String propertyName, MethodParameter methodParam) {
        Class elementType = null;
        if (methodParam != null && JdkVersion.isAtLeastJava15()) {
            elementType = GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)methodParam);
        }
        Collection convertedCopy = null;
        Iterator it = null;
        try {
            convertedCopy = CollectionFactory.createApproximateCollection((Object)original, (int)original.size());
            it = original.iterator();
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cannot access Collection of type [" + original.getClass().getName() + "] - injecting original Collection as-is"), ex);
            }
            return original;
        }
        boolean actuallyConverted = false;
        int i = 0;
        while (it.hasNext()) {
            Object element = it.next();
            String indexedPropertyName = this.buildIndexedPropertyName(propertyName, i);
            if (methodParam != null) {
                methodParam.increaseNestingLevel();
            }
            Object convertedElement = this.convertIfNecessary(indexedPropertyName, null, element, elementType, null, methodParam);
            if (methodParam != null) {
                methodParam.decreaseNestingLevel();
            }
            convertedCopy.add(convertedElement);
            actuallyConverted = actuallyConverted || element != convertedElement;
            ++i;
        }
        return actuallyConverted ? convertedCopy : original;
    }

    protected Map convertToTypedMap(Map original, String propertyName, MethodParameter methodParam) {
        Class keyType = null;
        Class valueType = null;
        if (methodParam != null && JdkVersion.isAtLeastJava15()) {
            keyType = GenericCollectionTypeResolver.getMapKeyParameterType((MethodParameter)methodParam);
            valueType = GenericCollectionTypeResolver.getMapValueParameterType((MethodParameter)methodParam);
        }
        Map convertedCopy = null;
        Iterator it = null;
        try {
            convertedCopy = CollectionFactory.createApproximateMap((Object)original, (int)original.size());
            it = original.entrySet().iterator();
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cannot access Map of type [" + original.getClass().getName() + "] - injecting original Map as-is"), ex);
            }
            return original;
        }
        boolean actuallyConverted = false;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            String keyedPropertyName = this.buildKeyedPropertyName(propertyName, key);
            if (methodParam != null) {
                methodParam.increaseNestingLevel();
            }
            Object convertedKey = this.convertIfNecessary(keyedPropertyName, null, key, keyType, null, methodParam);
            Object convertedValue = this.convertIfNecessary(keyedPropertyName, null, value, valueType, null, methodParam);
            if (methodParam != null) {
                methodParam.decreaseNestingLevel();
            }
            convertedCopy.put(convertedKey, convertedValue);
            actuallyConverted = actuallyConverted || key != convertedKey || value != convertedValue;
        }
        return actuallyConverted ? convertedCopy : original;
    }

    private String buildIndexedPropertyName(String propertyName, int index) {
        return propertyName != null ? propertyName + "[" + index + "]" : null;
    }

    private String buildKeyedPropertyName(String propertyName, Object key) {
        return propertyName != null ? propertyName + "[" + key + "]" : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

