/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.support;

import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;

public class ArgumentConvertingMethodInvoker
extends MethodInvoker {
    private TypeConverter typeConverter = new BeanWrapperImpl();

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        if (!(this.typeConverter instanceof PropertyEditorRegistry)) {
            throw new IllegalStateException("TypeConverter does not implement PropertyEditorRegistry interface: " + this.typeConverter);
        }
        ((PropertyEditorRegistry)((Object)this.typeConverter)).registerCustomEditor(requiredType, propertyEditor);
    }

    protected Method findMatchingMethod() {
        Class<?>[] paramTypes;
        int i;
        Method[] candidates = this.getTargetClass().getMethods();
        Object[] arguments = this.getArguments();
        int argCount = arguments.length;
        for (i = 0; i < candidates.length; ++i) {
            if (!candidates[i].getName().equals(this.getTargetMethod()) || (paramTypes = candidates[i].getParameterTypes()).length != argCount) continue;
            int numberOfCorrectArguments = 0;
            for (int j = 0; j < argCount; ++j) {
                if (!ClassUtils.isAssignableValue(paramTypes[j], (Object)arguments[j])) continue;
                ++numberOfCorrectArguments;
            }
            if (numberOfCorrectArguments != argCount) continue;
            return candidates[i];
        }
        if (this.typeConverter != null) {
            for (i = 0; i < candidates.length; ++i) {
                if (!candidates[i].getName().equals(this.getTargetMethod()) || (paramTypes = candidates[i].getParameterTypes()).length != argCount) continue;
                Object[] argumentsToUse = new Object[argCount];
                int numberOfCorrectArguments = 0;
                for (int j = 0; j < argCount; ++j) {
                    try {
                        argumentsToUse[j] = this.typeConverter.convertIfNecessary(arguments[j], paramTypes[j]);
                        ++numberOfCorrectArguments;
                        continue;
                    }
                    catch (TypeMismatchException ex) {
                        // empty catch block
                    }
                }
                if (numberOfCorrectArguments != argumentsToUse.length) continue;
                this.setArguments(argumentsToUse);
                return candidates[i];
            }
        }
        return null;
    }
}

