/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.ReflectionUtils;

class BeanTypeDescriptor
extends TypeDescriptor {
    private final PropertyDescriptor propertyDescriptor;
    private Annotation[] cachedAnnotations;

    public BeanTypeDescriptor(PropertyDescriptor propertyDescriptor) {
        super(BeanUtils.getWriteMethodParameter(propertyDescriptor));
        this.propertyDescriptor = propertyDescriptor;
    }

    public BeanTypeDescriptor(MethodParameter methodParameter, PropertyDescriptor propertyDescriptor) {
        super(methodParameter);
        this.propertyDescriptor = propertyDescriptor;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public Annotation[] getAnnotations() {
        Annotation[] anns = this.cachedAnnotations;
        if (anns == null) {
            Annotation ann;
            int n;
            int n2;
            Annotation[] annotationArray;
            Field underlyingField = ReflectionUtils.findField(this.getMethodParameter().getMethod().getDeclaringClass(), (String)this.propertyDescriptor.getName());
            LinkedHashMap<Class<? extends Annotation>, Annotation> annMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
            if (underlyingField != null) {
                Annotation[] annotationArray2 = underlyingField.getAnnotations();
                int n3 = annotationArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Annotation ann2 = annotationArray2[n4];
                    annMap.put(ann2.annotationType(), ann2);
                    ++n4;
                }
            }
            Method targetMethod = this.getMethodParameter().getMethod();
            Method writeMethod = this.propertyDescriptor.getWriteMethod();
            Method readMethod = this.propertyDescriptor.getReadMethod();
            if (writeMethod != null && writeMethod != targetMethod) {
                annotationArray = writeMethod.getAnnotations();
                n2 = annotationArray.length;
                n = 0;
                while (n < n2) {
                    ann = annotationArray[n];
                    annMap.put(ann.annotationType(), ann);
                    ++n;
                }
            }
            if (readMethod != null && readMethod != targetMethod) {
                annotationArray = readMethod.getAnnotations();
                n2 = annotationArray.length;
                n = 0;
                while (n < n2) {
                    ann = annotationArray[n];
                    annMap.put(ann.annotationType(), ann);
                    ++n;
                }
            }
            annotationArray = targetMethod.getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                ann = annotationArray[n];
                annMap.put(ann.annotationType(), ann);
                ++n;
            }
            anns = annMap.values().toArray(new Annotation[annMap.size()]);
            this.cachedAnnotations = anns;
        }
        return anns;
    }
}

