/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.util.Assert;

public class RootBeanDefinition
extends AbstractBeanDefinition {
    private final Set<Member> externallyManagedConfigMembers = Collections.newSetFromMap(new ConcurrentHashMap(0));
    private final Set<String> externallyManagedInitMethods = Collections.newSetFromMap(new ConcurrentHashMap(0));
    private final Set<String> externallyManagedDestroyMethods = Collections.newSetFromMap(new ConcurrentHashMap(0));
    private BeanDefinitionHolder decoratedDefinition;
    boolean allowCaching = true;
    private volatile Class<?> targetType;
    boolean isFactoryMethodUnique = false;
    final Object constructorArgumentLock = new Object();
    Object resolvedConstructorOrFactoryMethod;
    boolean constructorArgumentsResolved = false;
    Object[] resolvedConstructorArguments;
    Object[] preparedConstructorArguments;
    final Object postProcessingLock = new Object();
    boolean postProcessed = false;
    volatile Boolean beforeInstantiationResolved;

    public RootBeanDefinition() {
    }

    public RootBeanDefinition(Class<?> beanClass) {
        this.setBeanClass(beanClass);
    }

    public RootBeanDefinition(Class<?> beanClass, int autowireMode, boolean dependencyCheck) {
        this.setBeanClass(beanClass);
        this.setAutowireMode(autowireMode);
        if (dependencyCheck && this.getResolvedAutowireMode() != 3) {
            this.setDependencyCheck(1);
        }
    }

    public RootBeanDefinition(Class<?> beanClass, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(cargs, pvs);
        this.setBeanClass(beanClass);
    }

    public RootBeanDefinition(String beanClassName) {
        this.setBeanClassName(beanClassName);
    }

    public RootBeanDefinition(String beanClassName, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(cargs, pvs);
        this.setBeanClassName(beanClassName);
    }

    public RootBeanDefinition(RootBeanDefinition original) {
        super(original);
        this.decoratedDefinition = original.decoratedDefinition;
        this.allowCaching = original.allowCaching;
        this.targetType = original.targetType;
        this.isFactoryMethodUnique = original.isFactoryMethodUnique;
    }

    RootBeanDefinition(BeanDefinition original) {
        super(original);
    }

    @Override
    public String getParentName() {
        return null;
    }

    @Override
    public void setParentName(String parentName) {
        if (parentName != null) {
            throw new IllegalArgumentException("Root bean cannot be changed into a child bean with parent reference");
        }
    }

    public void setTargetType(Class<?> targetType) {
        this.targetType = targetType;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public void setUniqueFactoryMethodName(String name) {
        Assert.hasText((String)name, (String)"Factory method name must not be empty");
        this.setFactoryMethodName(name);
        this.isFactoryMethodUnique = true;
    }

    public boolean isFactoryMethod(Method candidate) {
        return candidate != null && candidate.getName().equals(this.getFactoryMethodName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getResolvedFactoryMethod() {
        Object object = this.constructorArgumentLock;
        synchronized (object) {
            Object candidate = this.resolvedConstructorOrFactoryMethod;
            return candidate instanceof Method ? (Method)candidate : null;
        }
    }

    public void registerExternallyManagedConfigMember(Member configMember) {
        this.externallyManagedConfigMembers.add(configMember);
    }

    public boolean isExternallyManagedConfigMember(Member configMember) {
        return this.externallyManagedConfigMembers.contains(configMember);
    }

    public void registerExternallyManagedInitMethod(String initMethod) {
        this.externallyManagedInitMethods.add(initMethod);
    }

    public boolean isExternallyManagedInitMethod(String initMethod) {
        return this.externallyManagedInitMethods.contains(initMethod);
    }

    public void registerExternallyManagedDestroyMethod(String destroyMethod) {
        this.externallyManagedDestroyMethods.add(destroyMethod);
    }

    public boolean isExternallyManagedDestroyMethod(String destroyMethod) {
        return this.externallyManagedDestroyMethods.contains(destroyMethod);
    }

    public void setDecoratedDefinition(BeanDefinitionHolder decoratedDefinition) {
        this.decoratedDefinition = decoratedDefinition;
    }

    public BeanDefinitionHolder getDecoratedDefinition() {
        return this.decoratedDefinition;
    }

    @Override
    public RootBeanDefinition cloneBeanDefinition() {
        return new RootBeanDefinition(this);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof RootBeanDefinition && super.equals(other);
    }

    @Override
    public String toString() {
        return "Root bean: " + super.toString();
    }
}

