/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.lang.reflect.Field;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class TypeConverterSupport
extends PropertyEditorRegistrySupport
implements TypeConverter {
    @Nullable
    TypeConverterDelegate typeConverterDelegate;

    @Override
    public <T> T convertIfNecessary(@Nullable Object value, @Nullable Class<T> requiredType) throws TypeMismatchException {
        return this.doConvert(value, requiredType, null, null);
    }

    @Override
    public <T> T convertIfNecessary(@Nullable Object value, @Nullable Class<T> requiredType, @Nullable MethodParameter methodParam) throws TypeMismatchException {
        return this.doConvert(value, requiredType, methodParam, null);
    }

    @Override
    public <T> T convertIfNecessary(@Nullable Object value, @Nullable Class<T> requiredType, @Nullable Field field) throws TypeMismatchException {
        return this.doConvert(value, requiredType, null, field);
    }

    @Nullable
    private <T> T doConvert(@Nullable Object value, @Nullable Class<T> requiredType, @Nullable MethodParameter methodParam, @Nullable Field field) throws TypeMismatchException {
        Assert.state((this.typeConverterDelegate != null ? 1 : 0) != 0, (String)"No TypeConverterDelegate");
        try {
            if (field != null) {
                return this.typeConverterDelegate.convertIfNecessary(value, requiredType, field);
            }
            return this.typeConverterDelegate.convertIfNecessary(value, requiredType, methodParam);
        }
        catch (IllegalStateException | ConverterNotFoundException ex) {
            throw new ConversionNotSupportedException(value, requiredType, ex);
        }
        catch (IllegalArgumentException | ConversionException ex) {
            throw new TypeMismatchException(value, requiredType, ex);
        }
    }
}

