/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGeneratorFactory;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import org.springframework.beans.factory.aot.BeanRegistrationCodeGenerator;
import org.springframework.beans.factory.aot.BeanRegistrationsCode;
import org.springframework.beans.factory.aot.DefaultBeanRegistrationCodeFragments;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.MethodParameter;
import org.springframework.javapoet.ClassName;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

class BeanDefinitionMethodGenerator {
    private final BeanDefinitionMethodGeneratorFactory methodGeneratorFactory;
    private final RegisteredBean registeredBean;
    private final Executable constructorOrFactoryMethod;
    @Nullable
    private final String currentPropertyName;
    private final List<BeanRegistrationAotContribution> aotContributions;

    BeanDefinitionMethodGenerator(BeanDefinitionMethodGeneratorFactory methodGeneratorFactory, RegisteredBean registeredBean, @Nullable String currentPropertyName, List<BeanRegistrationAotContribution> aotContributions) {
        this.methodGeneratorFactory = methodGeneratorFactory;
        this.registeredBean = registeredBean;
        this.constructorOrFactoryMethod = registeredBean.resolveConstructorOrFactoryMethod();
        this.currentPropertyName = currentPropertyName;
        this.aotContributions = aotContributions;
    }

    MethodReference generateBeanDefinitionMethod(GenerationContext generationContext, BeanRegistrationsCode beanRegistrationsCode) {
        this.registerRuntimeHintsIfNecessary(generationContext.getRuntimeHints());
        BeanRegistrationCodeFragments codeFragments = this.getCodeFragments(generationContext, beanRegistrationsCode);
        ClassName target = codeFragments.getTarget(this.registeredBean, this.constructorOrFactoryMethod);
        if (this.isWritablePackageName(target)) {
            GeneratedClass generatedClass = BeanDefinitionMethodGenerator.lookupGeneratedClass(generationContext, target);
            GeneratedMethods generatedMethods = generatedClass.getMethods().withPrefix(this.getName());
            GeneratedMethod generatedMethod = this.generateBeanDefinitionMethod(generationContext, generatedClass.getName(), generatedMethods, codeFragments, Modifier.PUBLIC);
            return generatedMethod.toMethodReference();
        }
        GeneratedMethods generatedMethods = beanRegistrationsCode.getMethods().withPrefix(this.getName());
        GeneratedMethod generatedMethod = this.generateBeanDefinitionMethod(generationContext, beanRegistrationsCode.getClassName(), generatedMethods, codeFragments, Modifier.PRIVATE);
        return generatedMethod.toMethodReference();
    }

    private boolean isWritablePackageName(ClassName target) {
        String packageName = target.packageName();
        return !packageName.startsWith("java.") && !packageName.startsWith("javax.");
    }

    private static GeneratedClass lookupGeneratedClass(GenerationContext generationContext, ClassName target) {
        ClassName topLevelClassName = target.topLevelClassName();
        GeneratedClass generatedClass = generationContext.getGeneratedClasses().getOrAddForFeatureComponent("BeanDefinitions", topLevelClassName, type -> {
            type.addJavadoc("Bean definitions for {@link $T}", new Object[]{topLevelClassName});
            type.addModifiers(new Modifier[]{Modifier.PUBLIC});
        });
        List names = target.simpleNames();
        if (names.size() == 1) {
            return generatedClass;
        }
        List namesToProcess = names.subList(1, names.size());
        ClassName currentTargetClassName = topLevelClassName;
        GeneratedClass tmp = generatedClass;
        for (String nameToProcess : namesToProcess) {
            currentTargetClassName = currentTargetClassName.nestedClass(nameToProcess);
            tmp = BeanDefinitionMethodGenerator.createInnerClass(tmp, nameToProcess + "__BeanDefinitions", currentTargetClassName);
        }
        return tmp;
    }

    private static GeneratedClass createInnerClass(GeneratedClass generatedClass, String name, ClassName target) {
        return generatedClass.getOrAdd(name, type -> {
            type.addJavadoc("Bean definitions for {@link $T}", new Object[]{target});
            type.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        });
    }

    private BeanRegistrationCodeFragments getCodeFragments(GenerationContext generationContext, BeanRegistrationsCode beanRegistrationsCode) {
        BeanRegistrationCodeFragments codeFragments = new DefaultBeanRegistrationCodeFragments(beanRegistrationsCode, this.registeredBean, this.methodGeneratorFactory);
        for (BeanRegistrationAotContribution aotContribution : this.aotContributions) {
            codeFragments = aotContribution.customizeBeanRegistrationCodeFragments(generationContext, codeFragments);
        }
        return codeFragments;
    }

    private GeneratedMethod generateBeanDefinitionMethod(GenerationContext generationContext, ClassName className, GeneratedMethods generatedMethods, BeanRegistrationCodeFragments codeFragments, Modifier modifier) {
        BeanRegistrationCodeGenerator codeGenerator = new BeanRegistrationCodeGenerator(className, generatedMethods, this.registeredBean, this.constructorOrFactoryMethod, codeFragments);
        this.aotContributions.forEach(aotContribution -> aotContribution.applyTo(generationContext, codeGenerator));
        return generatedMethods.add("getBeanDefinition", method -> {
            method.addJavadoc("Get the $L definition for '$L'", new Object[]{!this.registeredBean.isInnerBean() ? "bean" : "inner-bean", this.getName()});
            method.addModifiers(new Modifier[]{modifier, Modifier.STATIC});
            method.returns(BeanDefinition.class);
            method.addCode(codeGenerator.generateCode(generationContext));
        });
    }

    private String getName() {
        RegisteredBean nonGeneratedParent;
        if (this.currentPropertyName != null) {
            return this.currentPropertyName;
        }
        if (!this.registeredBean.isGeneratedBeanName()) {
            return this.getSimpleBeanName(this.registeredBean.getBeanName());
        }
        for (nonGeneratedParent = this.registeredBean; nonGeneratedParent != null && nonGeneratedParent.isGeneratedBeanName(); nonGeneratedParent = nonGeneratedParent.getParent()) {
        }
        if (nonGeneratedParent != null) {
            return this.getSimpleBeanName(nonGeneratedParent.getBeanName()) + "InnerBean";
        }
        return "innerBean";
    }

    private String getSimpleBeanName(String beanName) {
        int lastDot = beanName.lastIndexOf(46);
        beanName = lastDot != -1 ? beanName.substring(lastDot + 1) : beanName;
        int lastDollar = beanName.lastIndexOf(36);
        beanName = lastDollar != -1 ? beanName.substring(lastDollar + 1) : beanName;
        return StringUtils.uncapitalize((String)beanName);
    }

    private void registerRuntimeHintsIfNecessary(RuntimeHints runtimeHints) {
        ConfigurableListableBeanFactory configurableListableBeanFactory = this.registeredBean.getBeanFactory();
        if (configurableListableBeanFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)configurableListableBeanFactory;
            ProxyRuntimeHintsRegistrar registrar = new ProxyRuntimeHintsRegistrar(dlbf.getAutowireCandidateResolver());
            Executable executable = this.constructorOrFactoryMethod;
            if (executable instanceof Method) {
                Method method = (Method)executable;
                registrar.registerRuntimeHints(runtimeHints, method);
            } else {
                executable = this.constructorOrFactoryMethod;
                if (executable instanceof Constructor) {
                    Constructor constructor = (Constructor)executable;
                    registrar.registerRuntimeHints(runtimeHints, constructor);
                }
            }
        }
    }

    private static class ProxyRuntimeHintsRegistrar {
        private final AutowireCandidateResolver candidateResolver;

        public ProxyRuntimeHintsRegistrar(AutowireCandidateResolver candidateResolver) {
            this.candidateResolver = candidateResolver;
        }

        public void registerRuntimeHints(RuntimeHints runtimeHints, Method method) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                MethodParameter methodParam = new MethodParameter(method, i);
                DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(methodParam, true);
                this.registerProxyIfNecessary(runtimeHints, dependencyDescriptor);
            }
        }

        public void registerRuntimeHints(RuntimeHints runtimeHints, Constructor<?> constructor) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                MethodParameter methodParam = new MethodParameter(constructor, i);
                DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(methodParam, true);
                this.registerProxyIfNecessary(runtimeHints, dependencyDescriptor);
            }
        }

        private void registerProxyIfNecessary(RuntimeHints runtimeHints, DependencyDescriptor dependencyDescriptor) {
            Class<?> proxyType = this.candidateResolver.getLazyResolutionProxyClass(dependencyDescriptor, null);
            if (proxyType != null && Proxy.isProxyClass(proxyType)) {
                runtimeHints.proxies().registerJdkProxy((Class[])proxyType.getInterfaces());
            }
        }
    }
}

