/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.NullBean;

public class SimpleAutowireCandidateResolver
implements AutowireCandidateResolver {
    public static final SimpleAutowireCandidateResolver INSTANCE = new SimpleAutowireCandidateResolver();

    @Override
    public AutowireCandidateResolver cloneIfNecessary() {
        return this;
    }

    public static <T> Map<String, T> resolveAutowireCandidates(ConfigurableListableBeanFactory lbf, Class<T> type) {
        LinkedHashMap<String, Object> candidates = new LinkedHashMap<String, Object>();
        for (String beanName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)lbf, type)) {
            Object beanInstance;
            if (!AutowireUtils.isAutowireCandidate(lbf, beanName) || (beanInstance = lbf.getBean(beanName)) instanceof NullBean) continue;
            candidates.put(beanName, beanInstance);
        }
        return candidates;
    }
}

