/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.support;

import org.springframework.binding.convert.support.ConversionServiceAwareConverter;
import org.springframework.binding.util.MapAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class TextToClass
extends ConversionServiceAwareConverter {
    private static final String ALIAS_PREFIX = "type:";
    private static final String CLASS_PREFIX = "class:";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;

    public Class[] getSourceClasses() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = TextToClass.class$("java.lang.String")) : class$java$lang$String};
    }

    public Class[] getTargetClasses() {
        return new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = TextToClass.class$("java.lang.Class")) : class$java$lang$Class};
    }

    protected Object doConvert(Object source, Class targetClass, MapAccessor context) throws Exception {
        String text = (String)source;
        if (StringUtils.hasText((String)text)) {
            Class aliasedClass;
            String classNameOrAlias = text.trim();
            if (classNameOrAlias.startsWith(CLASS_PREFIX)) {
                return ClassUtils.forName((String)text.substring(CLASS_PREFIX.length()));
            }
            if (classNameOrAlias.startsWith(ALIAS_PREFIX)) {
                Class clazz = this.getConversionService().getClassByAlias(text);
                Assert.notNull((Object)clazz, (String)("No class found associated with type alias '" + classNameOrAlias + "'"));
                return clazz;
            }
            if (this.getConversionService() != null && (aliasedClass = this.getConversionService().getClassByAlias(text)) != null) {
                return aliasedClass;
            }
            return ClassUtils.forName((String)classNameOrAlias);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

