/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.mapping;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.PropertyExpression;
import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class Mapping
implements AttributeMapper,
Serializable {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$binding$mapping$Mapping == null ? (class$org$springframework$binding$mapping$Mapping = Mapping.class$("org.springframework.binding.mapping.Mapping")) : class$org$springframework$binding$mapping$Mapping));
    private final Expression sourceExpression;
    private final PropertyExpression targetPropertyExpression;
    private final ConversionExecutor typeConverter;
    static /* synthetic */ Class class$org$springframework$binding$mapping$Mapping;

    public Mapping(Expression sourceExpression, PropertyExpression targetPropertyExpression, ConversionExecutor typeConverter) {
        Assert.notNull((Object)sourceExpression, (String)"The source expression is required");
        Assert.notNull((Object)targetPropertyExpression, (String)"The target property expression is required");
        this.sourceExpression = sourceExpression;
        this.targetPropertyExpression = targetPropertyExpression;
        this.typeConverter = typeConverter;
    }

    public void map(Object source, Object target, Map mappingContext) {
        Object sourceValue;
        Object targetValue = sourceValue = this.sourceExpression.evaluateAgainst(source, mappingContext);
        if (this.typeConverter != null) {
            targetValue = this.typeConverter.execute(sourceValue);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Mapping " + this.sourceExpression + " value [" + sourceValue + "] to target property '" + this.targetPropertyExpression + "'; setting property value to [" + targetValue + "]"));
        }
        this.targetPropertyExpression.setValue(target, targetValue, mappingContext);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Mapping)) {
            return false;
        }
        Mapping other = (Mapping)o;
        return this.sourceExpression.equals(other.sourceExpression) && this.targetPropertyExpression.equals(other.targetPropertyExpression);
    }

    public int hashCode() {
        return this.sourceExpression.hashCode() + this.targetPropertyExpression.hashCode();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append((Object)(this.sourceExpression + " -> " + this.targetPropertyExpression)).append("typeConverter", (Object)this.typeConverter).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

