/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.binding.util.MapAdaptable;
import org.springframework.util.Assert;

public class MapAccessor
implements MapAdaptable {
    private Map map;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;

    public MapAccessor(Map map) {
        Assert.notNull((Object)map, (String)"The map to decorate is required");
        this.map = map;
    }

    public Map getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public Object get(Object key, Object defaultValue) {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        return this.map.get(key);
    }

    public Object get(Object key, Class requiredType) throws IllegalArgumentException {
        return this.get(key, requiredType, null);
    }

    public Object get(Object key, Class requiredType, Object defaultValue) {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        return this.assertKeyValueOfType(key, requiredType);
    }

    public Object getRequired(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return this.map.get(key);
    }

    public Object getRequired(Object key, Class requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return this.assertKeyValueOfType(key, requiredType);
    }

    public String getString(Object key) throws IllegalArgumentException {
        return this.getString(key, null);
    }

    public String getString(Object key, String defaultValue) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        return (String)this.assertKeyValueOfType(key, class$java$lang$String == null ? (class$java$lang$String = MapAccessor.class$("java.lang.String")) : class$java$lang$String);
    }

    public String getRequiredString(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return (String)this.assertKeyValueOfType(key, class$java$lang$String == null ? (class$java$lang$String = MapAccessor.class$("java.lang.String")) : class$java$lang$String);
    }

    public Collection getCollection(Object key) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return null;
        }
        return (Collection)this.assertKeyValueOfType(key, class$java$util$Collection == null ? (class$java$util$Collection = MapAccessor.class$("java.util.Collection")) : class$java$util$Collection);
    }

    public Collection getCollection(Object key, Class requiredType) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return null;
        }
        this.assertAssignableTo(class$java$util$Collection == null ? (class$java$util$Collection = MapAccessor.class$("java.util.Collection")) : class$java$util$Collection, requiredType);
        return (Collection)this.assertKeyValueOfType(key, requiredType);
    }

    public Collection getRequiredCollection(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return (Collection)this.assertKeyValueOfType(key, class$java$util$Collection == null ? (class$java$util$Collection = MapAccessor.class$("java.util.Collection")) : class$java$util$Collection);
    }

    public Collection getRequiredCollection(Object key, Class requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        this.assertAssignableTo(class$java$util$Collection == null ? (class$java$util$Collection = MapAccessor.class$("java.util.Collection")) : class$java$util$Collection, requiredType);
        return (Collection)this.assertKeyValueOfType(key, requiredType);
    }

    public Object[] getArray(Object key, Class requiredType) throws IllegalArgumentException {
        this.assertAssignableTo(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = MapAccessor.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, requiredType);
        if (!this.map.containsKey(key)) {
            return null;
        }
        return (Object[])this.assertKeyValueOfType(key, requiredType);
    }

    public Object[] getRequiredArray(Object key, Class requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        this.assertAssignableTo(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = MapAccessor.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, requiredType);
        return (Object[])this.assertKeyValueOfType(key, requiredType);
    }

    public Number getNumber(Object key, Class requiredType) throws IllegalArgumentException {
        return this.getNumber(key, requiredType, null);
    }

    public Number getNumber(Object key, Class requiredType, Number defaultValue) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        this.assertAssignableTo(class$java$lang$Number == null ? (class$java$lang$Number = MapAccessor.class$("java.lang.Number")) : class$java$lang$Number, requiredType);
        return (Number)this.assertKeyValueOfType(key, requiredType);
    }

    public Number getRequiredNumber(Object key, Class requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return (Number)this.assertKeyValueOfType(key, requiredType);
    }

    public Integer getInteger(Object key) throws IllegalArgumentException {
        return this.getInteger(key, null);
    }

    public Integer getInteger(Object key, Integer defaultValue) throws IllegalArgumentException {
        return (Integer)this.getNumber(key, class$java$lang$Integer == null ? (class$java$lang$Integer = MapAccessor.class$("java.lang.Integer")) : class$java$lang$Integer, defaultValue);
    }

    public Integer getRequiredInteger(Object key) throws IllegalArgumentException {
        return (Integer)this.getRequiredNumber(key, class$java$lang$Integer == null ? (class$java$lang$Integer = MapAccessor.class$("java.lang.Integer")) : class$java$lang$Integer);
    }

    public Long getLong(Object key) throws IllegalArgumentException {
        return this.getLong(key, null);
    }

    public Long getLong(Object key, Long defaultValue) throws IllegalArgumentException {
        return (Long)this.getNumber(key, class$java$lang$Long == null ? (class$java$lang$Long = MapAccessor.class$("java.lang.Long")) : class$java$lang$Long, defaultValue);
    }

    public Long getRequiredLong(Object key) throws IllegalArgumentException {
        return (Long)this.getRequiredNumber(key, class$java$lang$Long == null ? (class$java$lang$Long = MapAccessor.class$("java.lang.Long")) : class$java$lang$Long);
    }

    public Boolean getBoolean(Object key) throws IllegalArgumentException {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(Object key, Boolean defaultValue) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        return (Boolean)this.assertKeyValueOfType(key, class$java$lang$Boolean == null ? (class$java$lang$Boolean = MapAccessor.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    public Boolean getRequiredBoolean(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return (Boolean)this.assertKeyValueOfType(key, class$java$lang$Boolean == null ? (class$java$lang$Boolean = MapAccessor.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    public void assertContainsKey(Object key) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            throw new IllegalArgumentException("Required attribute '" + key + "' is not present in map; attributes present are [" + this.getMap() + "]");
        }
    }

    public boolean containsKey(Object key, Class requiredType) throws IllegalArgumentException {
        if (this.map.containsKey(key)) {
            this.assertKeyValueOfType(key, requiredType);
            return true;
        }
        return false;
    }

    public Object assertKeyValueOfType(Object key, Class requiredType) {
        return this.assertKeyValueInstanceOf(key, this.map.get(key), requiredType);
    }

    public Object assertKeyValueInstanceOf(Object key, Object value, Class requiredType) {
        Assert.notNull((Object)requiredType, (String)"The required type to assert is required");
        if (!requiredType.isInstance(value)) {
            throw new IllegalArgumentException("Map key '" + key + "' has value [" + value + "] that is not of expected type [" + requiredType + "], instead it is of type [" + (value != null ? value.getClass().getName() : "null") + "]");
        }
        return value;
    }

    private void assertAssignableTo(Class clazz, Class requiredType) {
        Assert.isTrue((boolean)clazz.isAssignableFrom(requiredType), (String)("The provided required type must be assignable to [" + clazz + "]"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

