/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class ClassPathXmlApplicationContext
extends AbstractXmlApplicationContext {
    private Resource[] configResources;
    private String[] configLocations;

    public ClassPathXmlApplicationContext(String configLocation) throws BeansException {
        this(new String[]{configLocation});
    }

    public ClassPathXmlApplicationContext(String[] configLocations) throws BeansException {
        this(configLocations, (ApplicationContext)null);
    }

    public ClassPathXmlApplicationContext(String[] configLocations, ApplicationContext parent) throws BeansException {
        super(parent);
        this.configLocations = configLocations;
        this.refresh();
    }

    public ClassPathXmlApplicationContext(String[] configLocations, boolean refresh) throws BeansException {
        this(configLocations, refresh, null);
    }

    public ClassPathXmlApplicationContext(String[] configLocations, boolean refresh, ApplicationContext parent) throws BeansException {
        super(parent);
        this.configLocations = configLocations;
        if (refresh) {
            this.refresh();
        }
    }

    public ClassPathXmlApplicationContext(String path, Class clazz) throws BeansException {
        this(new String[]{path}, clazz);
    }

    public ClassPathXmlApplicationContext(String[] paths, Class clazz) throws BeansException {
        this(paths, clazz, null);
    }

    public ClassPathXmlApplicationContext(String[] paths, Class clazz, ApplicationContext parent) throws BeansException {
        super(parent);
        Assert.notNull((Object)paths, (String)"Path array must not be null");
        Assert.notNull((Object)clazz, (String)"Class argument must not be null");
        this.configResources = new Resource[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            this.configResources[i] = new ClassPathResource(paths[i], clazz);
        }
        this.refresh();
    }

    protected Resource[] getConfigResources() {
        return this.configResources;
    }

    protected String[] getConfigLocations() {
        return this.configLocations;
    }
}

