/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationClassEnhancer {
    private static final Log logger = LogFactory.getLog(ConfigurationClassEnhancer.class);
    private final List<Callback> callbackInstances = new ArrayList<Callback>();
    private final List<Class<? extends Callback>> callbackTypes = new ArrayList<Class<? extends Callback>>();
    private final CallbackFilter callbackFilter;

    public ConfigurationClassEnhancer(ConfigurableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.callbackInstances.add((Callback)new BeanMethodInterceptor(beanFactory));
        this.callbackInstances.add((Callback)NoOp.INSTANCE);
        for (Callback callback : this.callbackInstances) {
            this.callbackTypes.add(callback.getClass());
        }
        this.callbackFilter = new CallbackFilter(){

            public int accept(Method candidateMethod) {
                return AnnotationUtils.findAnnotation((Method)candidateMethod, Bean.class) != null ? 0 : 1;
            }
        };
    }

    public Class enhance(Class configClass) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Enhancing " + configClass.getName()));
        }
        Class<?> enhancedClass = this.createClass(this.newEnhancer(configClass));
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Successfully enhanced %s; enhanced class name is: %s", configClass.getName(), enhancedClass.getName()));
        }
        return enhancedClass;
    }

    private Enhancer newEnhancer(Class<?> superclass) {
        Enhancer enhancer = new Enhancer();
        enhancer.setUseCache(false);
        enhancer.setSuperclass(superclass);
        enhancer.setUseFactory(false);
        enhancer.setCallbackFilter(this.callbackFilter);
        enhancer.setCallbackTypes(this.callbackTypes.toArray(new Class[this.callbackTypes.size()]));
        return enhancer;
    }

    private Class<?> createClass(Enhancer enhancer) {
        Class subclass = enhancer.createClass();
        Enhancer.registerStaticCallbacks((Class)subclass, (Callback[])this.callbackInstances.toArray(new Callback[this.callbackInstances.size()]));
        return subclass;
    }

    private static class BeanMethodInterceptor
    implements MethodInterceptor {
        private static final Log logger = LogFactory.getLog(BeanMethodInterceptor.class);
        private final ConfigurableBeanFactory beanFactory;

        public BeanMethodInterceptor(ConfigurableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            String scopedBeanName;
            Scope scope;
            String beanName = method.getName();
            Bean bean = (Bean)AnnotationUtils.findAnnotation((Method)method, Bean.class);
            if (bean != null && bean.name().length > 0) {
                beanName = bean.name()[0];
            }
            if ((scope = (Scope)AnnotationUtils.findAnnotation((Method)method, Scope.class)) != null && scope.proxyMode() != ScopedProxyMode.NO && this.beanFactory.isCurrentlyInCreation(scopedBeanName = ScopedProxyUtils.getTargetBeanName((String)beanName))) {
                beanName = scopedBeanName;
            }
            if (this.factoryContainsBean(beanName)) {
                Object cachedBean = this.beanFactory.getBean(beanName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Returning cached object [%s] for @Bean method %s.%s", cachedBean, method.getDeclaringClass().getSimpleName(), beanName));
                }
                return cachedBean;
            }
            return proxy.invokeSuper(obj, args);
        }

        private boolean factoryContainsBean(String beanName) {
            return this.beanFactory.containsBean(beanName) && !this.beanFactory.isCurrentlyInCreation(beanName);
        }
    }
}

