/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Array;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.TypeCode;

public class TypeReference
extends SpelNodeImpl {
    private final int dimensions;

    public TypeReference(int pos, SpelNodeImpl qualifiedId) {
        this(pos, qualifiedId, 0);
    }

    public TypeReference(int pos, SpelNodeImpl qualifiedId, int dims) {
        super(pos, qualifiedId);
        this.dimensions = dims;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypeCode tc;
        String typename = (String)this.children[0].getValueInternal(state).getValue();
        if (typename.indexOf(".") == -1 && Character.isLowerCase(typename.charAt(0)) && (tc = TypeCode.valueOf(typename.toUpperCase())) != TypeCode.OBJECT) {
            Class clazz = tc.getType();
            clazz = this.makeArrayIfNecessary(clazz);
            return new TypedValue(clazz);
        }
        Class clazz = state.findType(typename);
        clazz = this.makeArrayIfNecessary(clazz);
        return new TypedValue(clazz);
    }

    private Class makeArrayIfNecessary(Class clazz) {
        if (this.dimensions != 0) {
            for (int i = 0; i < this.dimensions; ++i) {
                Object o = Array.newInstance(clazz, 0);
                clazz = o.getClass();
            }
        }
        return clazz;
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append("T(");
        sb.append(this.getChild(0).toStringAST());
        for (int d = 0; d < this.dimensions; ++d) {
            sb.append("[]");
        }
        sb.append(")");
        return sb.toString();
    }
}

