/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Stack;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Opcodes;
import org.springframework.util.Assert;

public class CodeFlow
implements Opcodes {
    private final Stack<ArrayList<String>> compilationScopes = new Stack();

    public CodeFlow() {
        this.compilationScopes.add(new ArrayList());
    }

    public void loadTarget(MethodVisitor mv) {
        mv.visitVarInsn(25, 1);
    }

    public void pushDescriptor(String descriptor) {
        Assert.notNull((Object)descriptor);
        this.compilationScopes.peek().add(descriptor);
    }

    public void enterCompilationScope() {
        this.compilationScopes.push(new ArrayList());
    }

    public void exitCompilationScope() {
        this.compilationScopes.pop();
    }

    public String lastDescriptor() {
        if (this.compilationScopes.peek().size() == 0) {
            return null;
        }
        return this.compilationScopes.peek().get(this.compilationScopes.peek().size() - 1);
    }

    public void unboxBooleanIfNecessary(MethodVisitor mv) {
        if (this.lastDescriptor().equals("Ljava/lang/Boolean")) {
            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
        }
    }

    public static void insertUnboxInsns(MethodVisitor mv, char ch, boolean isObject) {
        switch (ch) {
            case 'I': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Integer");
                }
                mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                break;
            }
            case 'Z': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Boolean");
                }
                mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                break;
            }
            case 'B': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Byte");
                }
                mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
                break;
            }
            case 'C': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Character");
                }
                mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
                break;
            }
            case 'D': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Double");
                }
                mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
                break;
            }
            case 'S': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Short");
                }
                mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
                break;
            }
            case 'F': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Float");
                }
                mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
                break;
            }
            case 'J': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Long");
                }
                mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unboxing should not be attempted for descriptor '" + ch + "'");
            }
        }
    }

    public static String createSignatureDescriptor(Method method) {
        Class<?>[] params = method.getParameterTypes();
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Class<?> param : params) {
            sb.append(CodeFlow.toJVMDescriptor(param));
        }
        sb.append(")");
        sb.append(CodeFlow.toJVMDescriptor(method.getReturnType()));
        return sb.toString();
    }

    public static String createSignatureDescriptor(Constructor<?> ctor) {
        Class<?>[] params = ctor.getParameterTypes();
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Class<?> param : params) {
            sb.append(CodeFlow.toJVMDescriptor(param));
        }
        sb.append(")V");
        return sb.toString();
    }

    public static String toJVMDescriptor(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        if (clazz.isArray()) {
            while (clazz.isArray()) {
                sb.append("[");
                clazz = clazz.getComponentType();
            }
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                sb.append('V');
            } else if (clazz == Integer.TYPE) {
                sb.append('I');
            } else if (clazz == Boolean.TYPE) {
                sb.append('Z');
            } else if (clazz == Character.TYPE) {
                sb.append('C');
            } else if (clazz == Long.TYPE) {
                sb.append('J');
            } else if (clazz == Double.TYPE) {
                sb.append('D');
            } else if (clazz == Float.TYPE) {
                sb.append('F');
            } else if (clazz == Byte.TYPE) {
                sb.append('B');
            } else if (clazz == Short.TYPE) {
                sb.append('S');
            }
        } else {
            sb.append("L");
            sb.append(clazz.getName().replace('.', '/'));
            sb.append(";");
        }
        return sb.toString();
    }

    public static String toDescriptorFromObject(Object value) {
        if (value == null) {
            return "Ljava/lang/Object";
        }
        return CodeFlow.toDescriptor(value.getClass());
    }

    public static boolean isBooleanCompatible(String descriptor) {
        return descriptor != null && (descriptor.equals("Z") || descriptor.equals("Ljava/lang/Boolean"));
    }

    public static boolean isPrimitive(String descriptor) {
        return descriptor != null && descriptor.length() == 1;
    }

    public static boolean isPrimitiveArray(String descriptor) {
        boolean primitive = true;
        int max = descriptor.length();
        for (int i = 0; i < max; ++i) {
            char ch = descriptor.charAt(i);
            if (ch == '[') continue;
            primitive = ch != 'L';
            break;
        }
        return primitive;
    }

    public static boolean areBoxingCompatible(String desc1, String desc2) {
        if (desc1.equals(desc2)) {
            return true;
        }
        if (desc1.length() == 1) {
            if (desc1.equals("D")) {
                return desc2.equals("Ljava/lang/Double");
            }
            if (desc1.equals("F")) {
                return desc2.equals("Ljava/lang/Float");
            }
            if (desc1.equals("J")) {
                return desc2.equals("Ljava/lang/Long");
            }
            if (desc1.equals("I")) {
                return desc2.equals("Ljava/lang/Integer");
            }
            if (desc1.equals("Z")) {
                return desc2.equals("Ljava/lang/Boolean");
            }
        } else if (desc2.length() == 1) {
            if (desc2.equals("D")) {
                return desc1.equals("Ljava/lang/Double");
            }
            if (desc2.equals("F")) {
                return desc1.equals("Ljava/lang/Float");
            }
            if (desc2.equals("J")) {
                return desc1.equals("Ljava/lang/Long");
            }
            if (desc2.equals("I")) {
                return desc1.equals("Ljava/lang/Integer");
            }
            if (desc2.equals("Z")) {
                return desc1.equals("Ljava/lang/Boolean");
            }
        }
        return false;
    }

    public static boolean isPrimitiveOrUnboxableSupportedNumberOrBoolean(String descriptor) {
        if (descriptor == null) {
            return false;
        }
        if (descriptor.length() == 1) {
            return "DFJZI".indexOf(descriptor.charAt(0)) != -1;
        }
        return descriptor.startsWith("Ljava/lang/") && (descriptor.equals("Ljava/lang/Double") || descriptor.equals("Ljava/lang/Integer") || descriptor.equals("Ljava/lang/Float") || descriptor.equals("Ljava/lang/Long") || descriptor.equals("Ljava/lang/Boolean"));
    }

    public static boolean isPrimitiveOrUnboxableSupportedNumber(String descriptor) {
        if (descriptor == null) {
            return false;
        }
        if (descriptor.length() == 1) {
            return "DFJI".indexOf(descriptor.charAt(0)) != -1;
        }
        return descriptor.startsWith("Ljava/lang/") && (descriptor.equals("Ljava/lang/Double") || descriptor.equals("Ljava/lang/Integer") || descriptor.equals("Ljava/lang/Float") || descriptor.equals("Ljava/lang/Long"));
    }

    public static char toPrimitiveTargetDesc(String descriptor) {
        if (descriptor.length() == 1) {
            return descriptor.charAt(0);
        }
        if (descriptor.equals("Ljava/lang/Double")) {
            return 'D';
        }
        if (descriptor.equals("Ljava/lang/Integer")) {
            return 'I';
        }
        if (descriptor.equals("Ljava/lang/Float")) {
            return 'F';
        }
        if (descriptor.equals("Ljava/lang/Long")) {
            return 'J';
        }
        if (descriptor.equals("Ljava/lang/Boolean")) {
            return 'Z';
        }
        throw new IllegalStateException("No primitive for '" + descriptor + "'");
    }

    public static void insertCheckCast(MethodVisitor mv, String descriptor) {
        if (descriptor.length() != 1) {
            if (descriptor.charAt(0) == '[') {
                if (CodeFlow.isPrimitiveArray(descriptor)) {
                    mv.visitTypeInsn(192, descriptor);
                } else {
                    mv.visitTypeInsn(192, descriptor + ";");
                }
            } else {
                mv.visitTypeInsn(192, descriptor.substring(1));
            }
        }
    }

    public static void insertBoxIfNecessary(MethodVisitor mv, String descriptor) {
        if (descriptor.length() == 1) {
            CodeFlow.insertBoxIfNecessary(mv, descriptor.charAt(0));
        }
    }

    public static void insertBoxIfNecessary(MethodVisitor mv, char ch) {
        switch (ch) {
            case 'I': {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                break;
            }
            case 'F': {
                mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                break;
            }
            case 'S': {
                mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                break;
            }
            case 'Z': {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                break;
            }
            case 'J': {
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                break;
            }
            case 'D': {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                break;
            }
            case 'C': {
                mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                break;
            }
            case 'B': {
                mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                break;
            }
            case 'L': 
            case 'V': 
            case '[': {
                break;
            }
            default: {
                throw new IllegalArgumentException("Boxing should not be attempted for descriptor '" + ch + "'");
            }
        }
    }

    public static String toDescriptor(Class<?> type) {
        String name = type.getName();
        if (type.isPrimitive()) {
            switch (name.length()) {
                case 3: {
                    return "I";
                }
                case 4: {
                    if (name.equals("long")) {
                        return "J";
                    }
                    if (name.equals("char")) {
                        return "C";
                    }
                    if (name.equals("byte")) {
                        return "B";
                    }
                    if (!name.equals("void")) break;
                    return "V";
                }
                case 5: {
                    if (name.equals("float")) {
                        return "F";
                    }
                    if (!name.equals("short")) break;
                    return "S";
                }
                case 6: {
                    if (!name.equals("double")) break;
                    return "D";
                }
                case 7: {
                    if (!name.equals("boolean")) break;
                    return "Z";
                }
            }
        } else {
            if (name.charAt(0) != '[') {
                return "L" + type.getName().replace('.', '/');
            }
            if (name.endsWith(";")) {
                return name.substring(0, name.length() - 1).replace('.', '/');
            }
            return name;
        }
        return null;
    }

    public static String[] toParamDescriptors(Method method) {
        return CodeFlow.toDescriptors(method.getParameterTypes());
    }

    public static String[] toParamDescriptors(Constructor<?> ctor) {
        return CodeFlow.toDescriptors(ctor.getParameterTypes());
    }

    private static String[] toDescriptors(Class<?>[] types) {
        int typesCount = types.length;
        String[] descriptors = new String[typesCount];
        for (int p = 0; p < typesCount; ++p) {
            descriptors[p] = CodeFlow.toDescriptor(types[p]);
        }
        return descriptors;
    }
}

