/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OpEQ
extends Operator {
    public OpEQ(int pos, SpelNodeImpl ... operands) {
        super("==", pos, operands);
        this.exitTypeDescriptor = "Z";
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        Object left = this.getLeftOperand().getValueInternal(state).getValue();
        Object right = this.getRightOperand().getValueInternal(state).getValue();
        return BooleanTypedValue.forValue(this.equalityCheck(state, left, right));
    }

    @Override
    public boolean isCompilable() {
        SpelNodeImpl left = this.getLeftOperand();
        SpelNodeImpl right = this.getRightOperand();
        if (!left.isCompilable() || !right.isCompilable()) {
            return false;
        }
        String leftdesc = left.getExitDescriptor();
        String rightdesc = right.getExitDescriptor();
        return !CodeFlow.isPrimitiveOrUnboxableSupportedNumberOrBoolean(leftdesc) && !CodeFlow.isPrimitiveOrUnboxableSupportedNumber(rightdesc) || CodeFlow.areBoxingCompatible(leftdesc, rightdesc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void generateCode(MethodVisitor mv, CodeFlow codeflow) {
        String leftDesc = this.getLeftOperand().getExitDescriptor();
        String rightDesc = this.getRightOperand().getExitDescriptor();
        Label elseTarget = new Label();
        Label endOfIf = new Label();
        boolean leftPrim = CodeFlow.isPrimitive(leftDesc);
        boolean rightPrim = CodeFlow.isPrimitive(rightDesc);
        if ((CodeFlow.isPrimitiveOrUnboxableSupportedNumberOrBoolean(leftDesc) || CodeFlow.isPrimitiveOrUnboxableSupportedNumberOrBoolean(rightDesc)) && CodeFlow.areBoxingCompatible(leftDesc, rightDesc)) {
            char targetType = CodeFlow.toPrimitiveTargetDesc(leftDesc);
            this.getLeftOperand().generateCode(mv, codeflow);
            if (!leftPrim) {
                CodeFlow.insertUnboxInsns(mv, targetType, false);
            }
            this.getRightOperand().generateCode(mv, codeflow);
            if (!rightPrim) {
                CodeFlow.insertUnboxInsns(mv, targetType, false);
            }
            if (targetType == 'D') {
                mv.visitInsn(151);
                mv.visitJumpInsn(154, elseTarget);
            } else if (targetType == 'F') {
                mv.visitInsn(149);
                mv.visitJumpInsn(154, elseTarget);
            } else if (targetType == 'J') {
                mv.visitInsn(148);
                mv.visitJumpInsn(154, elseTarget);
            } else {
                if (targetType != 'I' && targetType != 'Z') throw new IllegalStateException("Unexpected descriptor " + leftDesc);
                mv.visitJumpInsn(160, elseTarget);
            }
        } else {
            this.getLeftOperand().generateCode(mv, codeflow);
            this.getRightOperand().generateCode(mv, codeflow);
            Label leftNotNull = new Label();
            mv.visitInsn(90);
            mv.visitJumpInsn(199, leftNotNull);
            mv.visitInsn(95);
            mv.visitInsn(87);
            Label rightNotNull = new Label();
            mv.visitJumpInsn(199, rightNotNull);
            mv.visitInsn(4);
            mv.visitJumpInsn(167, endOfIf);
            mv.visitLabel(rightNotNull);
            mv.visitInsn(3);
            mv.visitJumpInsn(167, endOfIf);
            mv.visitLabel(leftNotNull);
            mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z", false);
            mv.visitLabel(endOfIf);
            codeflow.pushDescriptor("Z");
            return;
        }
        mv.visitInsn(4);
        mv.visitJumpInsn(167, endOfIf);
        mv.visitLabel(elseTarget);
        mv.visitInsn(3);
        mv.visitLabel(endOfIf);
        codeflow.pushDescriptor("Z");
    }
}

