/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.math.BigDecimal;
import org.springframework.asm.MethodVisitor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Operation;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.util.NumberUtils;

public class OpMultiply
extends Operator {
    public OpMultiply(int pos, SpelNodeImpl ... operands) {
        super("*", pos, operands);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        Object leftOperand = this.getLeftOperand().getValueInternal(state).getValue();
        Object rightOperand = this.getRightOperand().getValueInternal(state).getValue();
        if (leftOperand instanceof Number && rightOperand instanceof Number) {
            Number leftNumber = (Number)leftOperand;
            Number rightNumber = (Number)rightOperand;
            if (leftNumber instanceof BigDecimal || rightNumber instanceof BigDecimal) {
                BigDecimal leftBigDecimal = (BigDecimal)NumberUtils.convertNumberToTargetClass((Number)leftNumber, BigDecimal.class);
                BigDecimal rightBigDecimal = (BigDecimal)NumberUtils.convertNumberToTargetClass((Number)rightNumber, BigDecimal.class);
                return new TypedValue(leftBigDecimal.multiply(rightBigDecimal));
            }
            if (leftNumber instanceof Double || rightNumber instanceof Double) {
                if (leftNumber instanceof Double && rightNumber instanceof Double) {
                    this.exitTypeDescriptor = "D";
                }
                return new TypedValue(leftNumber.doubleValue() * rightNumber.doubleValue());
            }
            if (leftNumber instanceof Float || rightNumber instanceof Float) {
                if (leftNumber instanceof Float && rightNumber instanceof Float) {
                    this.exitTypeDescriptor = "F";
                }
                return new TypedValue(Float.valueOf(leftNumber.floatValue() * rightNumber.floatValue()));
            }
            if (leftNumber instanceof Long || rightNumber instanceof Long) {
                if (leftNumber instanceof Long && rightNumber instanceof Long) {
                    this.exitTypeDescriptor = "J";
                }
                return new TypedValue(leftNumber.longValue() * rightNumber.longValue());
            }
            if (leftNumber instanceof Integer && rightNumber instanceof Integer) {
                this.exitTypeDescriptor = "I";
            }
            return new TypedValue(leftNumber.intValue() * rightNumber.intValue());
        }
        if (leftOperand instanceof String && rightOperand instanceof Integer) {
            int repeats = (Integer)rightOperand;
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < repeats; ++i) {
                result.append(leftOperand);
            }
            return new TypedValue(result.toString());
        }
        return state.operate(Operation.MULTIPLY, leftOperand, rightOperand);
    }

    @Override
    public boolean isCompilable() {
        if (!this.getLeftOperand().isCompilable()) {
            return false;
        }
        if (this.children.length > 1 && !this.getRightOperand().isCompilable()) {
            return false;
        }
        return this.exitTypeDescriptor != null;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow codeflow) {
        this.getLeftOperand().generateCode(mv, codeflow);
        String leftdesc = this.getLeftOperand().getExitDescriptor();
        if (!CodeFlow.isPrimitive(leftdesc)) {
            CodeFlow.insertUnboxInsns(mv, this.exitTypeDescriptor.charAt(0), false);
        }
        if (this.children.length > 1) {
            this.getRightOperand().generateCode(mv, codeflow);
            String rightdesc = this.getRightOperand().getExitDescriptor();
            if (!CodeFlow.isPrimitive(rightdesc)) {
                CodeFlow.insertUnboxInsns(mv, this.exitTypeDescriptor.charAt(0), false);
            }
            switch (this.exitTypeDescriptor.charAt(0)) {
                case 'I': {
                    mv.visitInsn(104);
                    break;
                }
                case 'J': {
                    mv.visitInsn(105);
                    break;
                }
                case 'F': {
                    mv.visitInsn(106);
                    break;
                }
                case 'D': {
                    mv.visitInsn(107);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized exit descriptor: '" + this.exitTypeDescriptor + "'");
                }
            }
        }
        codeflow.pushDescriptor(this.exitTypeDescriptor);
    }
}

