/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.cci.connection;

import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jca.cci.CannotGetCciConnectionException;
import org.springframework.jca.cci.connection.ConnectionHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class ConnectionFactoryUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jca$cci$connection$ConnectionFactoryUtils == null ? (class$org$springframework$jca$cci$connection$ConnectionFactoryUtils = ConnectionFactoryUtils.class$("org.springframework.jca.cci.connection.ConnectionFactoryUtils")) : class$org$springframework$jca$cci$connection$ConnectionFactoryUtils));
    static /* synthetic */ Class class$org$springframework$jca$cci$connection$ConnectionFactoryUtils;

    public static Connection getConnection(ConnectionFactory cf) throws CannotGetCciConnectionException {
        return ConnectionFactoryUtils.getConnection(cf, null);
    }

    public static Connection getConnection(ConnectionFactory cf, ConnectionSpec spec) throws CannotGetCciConnectionException {
        try {
            if (spec != null) {
                Assert.notNull((Object)cf, (String)"No ConnectionFactory specified");
                return cf.getConnection(spec);
            }
            return ConnectionFactoryUtils.doGetConnection(cf);
        }
        catch (ResourceException ex) {
            throw new CannotGetCciConnectionException("Could not get CCI Connection", ex);
        }
    }

    public static Connection doGetConnection(ConnectionFactory cf) throws ResourceException {
        Assert.notNull((Object)cf, (String)"No ConnectionFactory specified");
        ConnectionHolder conHolder = (ConnectionHolder)((Object)TransactionSynchronizationManager.getResource((Object)cf));
        if (conHolder != null) {
            return conHolder.getConnection();
        }
        logger.debug((Object)"Opening CCI Connection");
        Connection con = cf.getConnection();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug((Object)"Registering transaction synchronization for CCI Connection");
            conHolder = new ConnectionHolder(con);
            conHolder.setSynchronizedWithTransaction(true);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new ConnectionSynchronization(conHolder, cf));
            TransactionSynchronizationManager.bindResource((Object)cf, (Object)((Object)conHolder));
        }
        return con;
    }

    public static boolean isConnectionTransactional(Connection con, ConnectionFactory cf) {
        if (cf == null) {
            return false;
        }
        ConnectionHolder conHolder = (ConnectionHolder)((Object)TransactionSynchronizationManager.getResource((Object)cf));
        return conHolder != null && conHolder.getConnection() == con;
    }

    public static void releaseConnection(Connection con, ConnectionFactory cf) {
        try {
            ConnectionFactoryUtils.doReleaseConnection(con, cf);
        }
        catch (ResourceException ex) {
            logger.debug((Object)"Could not close CCI Connection", (Throwable)ex);
        }
        catch (Throwable ex) {
            logger.debug((Object)"Unexpected exception on closing CCI Connection", ex);
        }
    }

    public static void doReleaseConnection(Connection con, ConnectionFactory cf) throws ResourceException {
        if (con == null || ConnectionFactoryUtils.isConnectionTransactional(con, cf)) {
            return;
        }
        con.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ConnectionSynchronization
    extends TransactionSynchronizationAdapter {
        private final ConnectionHolder connectionHolder;
        private final ConnectionFactory connectionFactory;
        private boolean holderActive = true;

        public ConnectionSynchronization(ConnectionHolder connectionHolder, ConnectionFactory connectionFactory) {
            this.connectionHolder = connectionHolder;
            this.connectionFactory = connectionFactory;
        }

        public void suspend() {
            if (this.holderActive) {
                TransactionSynchronizationManager.unbindResource((Object)this.connectionFactory);
            }
        }

        public void resume() {
            if (this.holderActive) {
                TransactionSynchronizationManager.bindResource((Object)this.connectionFactory, (Object)((Object)this.connectionHolder));
            }
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource((Object)this.connectionFactory);
            this.holderActive = false;
            ConnectionFactoryUtils.releaseConnection(this.connectionHolder.getConnection(), this.connectionFactory);
        }
    }
}

