/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.util.Assert;

public class SQLStateSQLExceptionTranslator
implements SQLExceptionTranslator {
    private static final Set BAD_SQL_CODES = new HashSet(6);
    private static final Set INTEGRITY_VIOLATION_CODES = new HashSet(4);
    private static final Set RESOURCE_FAILURE_CODES = new HashSet(3);
    private static final Set CONCURRENCY_CODES = new HashSet(1);
    protected final Log logger = LogFactory.getLog(this.getClass());

    public DataAccessException translate(String task, String sql, SQLException ex) {
        String sqlState;
        Assert.notNull((Object)ex, (String)"Cannot translate a null SQLException.");
        if (task == null) {
            task = "";
        }
        if (sql == null) {
            sql = "";
        }
        if ((sqlState = this.getSqlState(ex)) != null && sqlState.length() >= 2) {
            String classCode = sqlState.substring(0, 2);
            if (BAD_SQL_CODES.contains(classCode)) {
                return new BadSqlGrammarException(task, sql, ex);
            }
            if (INTEGRITY_VIOLATION_CODES.contains(classCode)) {
                return new DataIntegrityViolationException(this.buildMessage(task, sql, ex), (Throwable)ex);
            }
            if (RESOURCE_FAILURE_CODES.contains(classCode)) {
                return new DataAccessResourceFailureException(this.buildMessage(task, sql, ex), (Throwable)ex);
            }
            if (CONCURRENCY_CODES.contains(classCode)) {
                return new ConcurrencyFailureException(this.buildMessage(task, sql, ex), (Throwable)ex);
            }
        }
        return new UncategorizedSQLException(task, sql, ex);
    }

    protected String buildMessage(String task, String sql, SQLException ex) {
        return task + "; SQL [" + sql + "]; " + ex.getMessage();
    }

    private String getSqlState(SQLException ex) {
        SQLException nestedEx;
        String sqlState = ex.getSQLState();
        if (sqlState == null && (nestedEx = ex.getNextException()) != null) {
            sqlState = nestedEx.getSQLState();
        }
        return sqlState;
    }

    static {
        BAD_SQL_CODES.add("07");
        BAD_SQL_CODES.add("21");
        BAD_SQL_CODES.add("37");
        BAD_SQL_CODES.add("42");
        BAD_SQL_CODES.add("2A");
        BAD_SQL_CODES.add("65");
        BAD_SQL_CODES.add("S0");
        INTEGRITY_VIOLATION_CODES.add("22");
        INTEGRITY_VIOLATION_CODES.add("23");
        INTEGRITY_VIOLATION_CODES.add("27");
        INTEGRITY_VIOLATION_CODES.add("44");
        CONCURRENCY_CODES.add("40");
        RESOURCE_FAILURE_CODES.add("08");
        RESOURCE_FAILURE_CODES.add("53");
        RESOURCE_FAILURE_CODES.add("54");
    }
}

