/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import org.springframework.jms.connection.CachedMessageConsumer;
import org.springframework.jms.connection.CachedMessageProducer;
import org.springframework.jms.connection.SessionProxy;
import org.springframework.jms.connection.SingleConnectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class CachingConnectionFactory
extends SingleConnectionFactory {
    private int sessionCacheSize = 1;
    private boolean cacheProducers = true;
    private boolean cacheConsumers = true;
    private volatile boolean active = true;
    private final Map cachedSessions = new HashMap();

    public CachingConnectionFactory() {
        this.setReconnectOnException(true);
    }

    public CachingConnectionFactory(ConnectionFactory targetConnectionFactory) {
        super(targetConnectionFactory);
        this.setReconnectOnException(true);
    }

    public void setSessionCacheSize(int sessionCacheSize) {
        Assert.isTrue((sessionCacheSize >= 1 ? 1 : 0) != 0, (String)"Session cache size must be 1 or higher");
        this.sessionCacheSize = sessionCacheSize;
    }

    public int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    public void setCacheProducers(boolean cacheProducers) {
        this.cacheProducers = cacheProducers;
    }

    public boolean isCacheProducers() {
        return this.cacheProducers;
    }

    public void setCacheConsumers(boolean cacheConsumers) {
        this.cacheConsumers = cacheConsumers;
    }

    public boolean isCacheConsumers() {
        return this.cacheConsumers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        this.active = false;
        Map map = this.cachedSessions;
        synchronized (map) {
            Iterator it = this.cachedSessions.values().iterator();
            while (it.hasNext()) {
                LinkedList sessionList;
                LinkedList linkedList = sessionList = (LinkedList)it.next();
                synchronized (linkedList) {
                    Iterator it2 = sessionList.iterator();
                    while (it2.hasNext()) {
                        Session session = (Session)it2.next();
                        try {
                            session.close();
                        }
                        catch (Throwable ex) {
                            this.logger.trace((Object)"Could not close cached JMS Session", ex);
                        }
                    }
                }
            }
            this.cachedSessions.clear();
        }
        this.active = true;
        super.resetConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session getSession(Connection con, Integer mode) throws JMSException {
        LinkedList sessionList = null;
        Map map = this.cachedSessions;
        synchronized (map) {
            sessionList = (LinkedList)this.cachedSessions.get(mode);
            if (sessionList == null) {
                sessionList = new LinkedList();
                this.cachedSessions.put(mode, sessionList);
            }
        }
        Session session = null;
        LinkedList linkedList = sessionList;
        synchronized (linkedList) {
            if (!sessionList.isEmpty()) {
                session = (Session)sessionList.removeFirst();
            }
        }
        if (session != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Found cached JMS Session for mode " + mode + ": " + (session instanceof SessionProxy ? ((SessionProxy)session).getTargetSession() : session)));
            }
        } else {
            Session targetSession = this.createSession(con, mode);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating cached JMS Session for mode " + mode + ": " + targetSession));
            }
            session = this.getCachedSessionProxy(targetSession, sessionList);
        }
        return session;
    }

    protected Session getCachedSessionProxy(Session target, LinkedList sessionList) {
        ArrayList<Class> classes = new ArrayList<Class>(3);
        classes.add(SessionProxy.class);
        if (target instanceof QueueSession) {
            classes.add(QueueSession.class);
        }
        if (target instanceof TopicSession) {
            classes.add(TopicSession.class);
        }
        return (Session)Proxy.newProxyInstance(SessionProxy.class.getClassLoader(), classes.toArray(new Class[classes.size()]), (InvocationHandler)new CachedSessionInvocationHandler(target, sessionList));
    }

    private static class ConsumerCacheKey {
        private final Destination destination;
        private final String selector;
        private final boolean noLocal;
        private final String subscription;

        private ConsumerCacheKey(Destination destination, String selector, boolean noLocal, String subscription) {
            this.destination = destination;
            this.selector = selector;
            this.noLocal = noLocal;
            this.subscription = subscription;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            ConsumerCacheKey otherKey = (ConsumerCacheKey)other;
            return this.destination.equals(otherKey.destination) && ObjectUtils.nullSafeEquals((Object)this.selector, (Object)otherKey.selector) && this.noLocal == otherKey.noLocal && ObjectUtils.nullSafeEquals((Object)this.subscription, (Object)otherKey.subscription);
        }

        public int hashCode() {
            return this.destination.hashCode();
        }
    }

    private class CachedSessionInvocationHandler
    implements InvocationHandler {
        private final Session target;
        private final LinkedList sessionList;
        private final Map cachedProducers = new HashMap();
        private final Map cachedConsumers = new HashMap();
        private boolean transactionOpen = false;

        public CachedSessionInvocationHandler(Session target, LinkedList sessionList) {
            this.target = target;
            this.sessionList = sessionList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (methodName.equals("hashCode")) {
                return new Integer(System.identityHashCode(proxy));
            }
            if (methodName.equals("toString")) {
                return "Cached JMS Session: " + this.target;
            }
            if (methodName.equals("close")) {
                if (CachingConnectionFactory.this.active) {
                    LinkedList linkedList = this.sessionList;
                    synchronized (linkedList) {
                        if (this.sessionList.size() < CachingConnectionFactory.this.getSessionCacheSize()) {
                            this.logicalClose(proxy);
                            return null;
                        }
                    }
                }
                this.physicalClose();
                return null;
            }
            if (methodName.equals("getTargetSession")) {
                return this.target;
            }
            if (methodName.equals("commit") || methodName.equals("rollback")) {
                this.transactionOpen = false;
            } else {
                this.transactionOpen = true;
                if ((methodName.equals("createProducer") || methodName.equals("createSender") || methodName.equals("createPublisher")) && CachingConnectionFactory.this.isCacheProducers()) {
                    return this.getCachedProducer((Destination)args[0]);
                }
                if ((methodName.equals("createConsumer") || methodName.equals("createReceiver") || methodName.equals("createSubscriber")) && CachingConnectionFactory.this.isCacheConsumers()) {
                    return this.getCachedConsumer((Destination)args[0], args.length > 1 ? (String)args[1] : null, args.length > 2 && (Boolean)args[2] != false, null);
                }
                if (methodName.equals("createDurableSubscriber") && CachingConnectionFactory.this.isCacheConsumers()) {
                    return this.getCachedConsumer((Destination)args[0], args.length > 2 ? (String)args[2] : null, args.length > 3 && (Boolean)args[3] != false, (String)args[1]);
                }
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        private MessageProducer getCachedProducer(Destination dest) throws JMSException {
            MessageProducer producer = (MessageProducer)this.cachedProducers.get(dest);
            if (producer != null) {
                if (CachingConnectionFactory.this.logger.isTraceEnabled()) {
                    CachingConnectionFactory.this.logger.trace((Object)("Found cached JMS MessageProducer for destination [" + dest + "]: " + producer));
                }
            } else {
                producer = this.target.createProducer(dest);
                if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                    CachingConnectionFactory.this.logger.debug((Object)("Creating cached JMS MessageProducer for destination [" + dest + "]: " + producer));
                }
                this.cachedProducers.put(dest, producer);
            }
            return new CachedMessageProducer(producer);
        }

        private MessageConsumer getCachedConsumer(Destination dest, String selector, boolean noLocal, String subscription) throws JMSException {
            ConsumerCacheKey cacheKey = new ConsumerCacheKey(dest, selector, noLocal, subscription);
            Object consumer = (MessageConsumer)this.cachedConsumers.get(cacheKey);
            if (consumer != null) {
                if (CachingConnectionFactory.this.logger.isTraceEnabled()) {
                    CachingConnectionFactory.this.logger.trace((Object)("Found cached JMS MessageConsumer for destination [" + dest + "]: " + consumer));
                }
            } else {
                consumer = dest instanceof Topic ? (subscription != null ? this.target.createDurableSubscriber((Topic)dest, subscription, selector, noLocal) : this.target.createConsumer(dest, selector, noLocal)) : this.target.createConsumer(dest, selector);
                if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                    CachingConnectionFactory.this.logger.debug((Object)("Creating cached JMS MessageConsumer for destination [" + dest + "]: " + consumer));
                }
                this.cachedConsumers.put(cacheKey, consumer);
            }
            return new CachedMessageConsumer((MessageConsumer)consumer);
        }

        private void logicalClose(Object proxy) throws JMSException {
            if (this.transactionOpen && this.target.getTransacted()) {
                this.transactionOpen = false;
                this.target.rollback();
            }
            Iterator it = this.cachedConsumers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ConsumerCacheKey key = (ConsumerCacheKey)entry.getKey();
                if (key.subscription == null) continue;
                ((MessageConsumer)entry.getValue()).close();
                it.remove();
            }
            if (!this.sessionList.contains(proxy)) {
                if (CachingConnectionFactory.this.logger.isTraceEnabled()) {
                    CachingConnectionFactory.this.logger.trace((Object)("Returning cached Session: " + this.target));
                }
                this.sessionList.addLast(proxy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void physicalClose() throws JMSException {
            if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                CachingConnectionFactory.this.logger.debug((Object)("Closing cached Session: " + this.target));
            }
            try {
                Iterator it = this.cachedProducers.values().iterator();
                while (it.hasNext()) {
                    ((MessageProducer)it.next()).close();
                }
                it = this.cachedConsumers.values().iterator();
                while (it.hasNext()) {
                    ((MessageConsumer)it.next()).close();
                }
            }
            finally {
                this.cachedProducers.clear();
                this.cachedConsumers.clear();
                this.target.close();
            }
        }
    }
}

