/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.jndi.JndiLocatorSupport;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.ExtendedEntityManagerCreator;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceAnnotationBeanPostProcessor
extends JndiLocatorSupport
implements InstantiationAwareBeanPostProcessor,
BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Map<String, String> persistenceUnits;
    private Map<String, String> persistenceContexts;
    private Map<String, String> extendedPersistenceContexts;
    private String defaultPersistenceUnitName = "";
    private ListableBeanFactory beanFactory;
    private Map<Class<?>, List<AnnotatedMember>> classMetadata = new HashMap();

    public PersistenceAnnotationBeanPostProcessor() {
        this.setResourceRef(true);
    }

    public void setPersistenceUnits(Map<String, String> persistenceUnits) {
        this.persistenceUnits = persistenceUnits;
    }

    public void setPersistenceContexts(Map<String, String> persistenceContexts) {
        this.persistenceContexts = persistenceContexts;
    }

    public void setExtendedPersistenceContexts(Map<String, String> extendedPersistenceContexts) {
        this.extendedPersistenceContexts = extendedPersistenceContexts;
    }

    public void setDefaultPersistenceUnitName(String unitName) {
        this.defaultPersistenceUnitName = unitName != null ? unitName : "";
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ListableBeanFactory) {
            this.beanFactory = (ListableBeanFactory)beanFactory;
        }
    }

    public Object postProcessBeforeInstantiation(Class beanClass, String beanName) throws BeansException {
        return null;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        List<AnnotatedMember> metadata = this.findClassMetadata(bean.getClass());
        for (AnnotatedMember member : metadata) {
            member.inject(bean);
        }
        return true;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        return pvs;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AnnotatedMember> findClassMetadata(Class<? extends Object> clazz) {
        Map<Class<?>, List<AnnotatedMember>> map = this.classMetadata;
        synchronized (map) {
            List<AnnotatedMember> metadata = this.classMetadata.get(clazz);
            if (metadata == null) {
                final LinkedList<AnnotatedMember> newMetadata = new LinkedList<AnnotatedMember>();
                ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                    public void doWith(Field field) {
                        PersistenceAnnotationBeanPostProcessor.this.addIfPresent(newMetadata, field);
                    }
                });
                ReflectionUtils.doWithMethods(clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                    public void doWith(Method method) {
                        PersistenceAnnotationBeanPostProcessor.this.addIfPresent(newMetadata, method);
                    }
                });
                metadata = newMetadata;
                this.classMetadata.put(clazz, metadata);
            }
            return metadata;
        }
    }

    private void addIfPresent(List<AnnotatedMember> metadata, Member member) {
        AnnotatedElement ae = (AnnotatedElement)((Object)member);
        PersistenceContext pc = ae.getAnnotation(PersistenceContext.class);
        if (pc != null) {
            Properties properties = null;
            Object[] pps = pc.properties();
            if (!ObjectUtils.isEmpty((Object[])pps)) {
                properties = new Properties();
                for (int i = 0; i < pps.length; ++i) {
                    Object pp = pps[i];
                    properties.setProperty(pp.name(), pp.value());
                }
            }
            metadata.add(new AnnotatedMember(member, pc.unitName(), pc.type(), properties));
        } else {
            PersistenceUnit pu = ae.getAnnotation(PersistenceUnit.class);
            if (pu != null) {
                metadata.add(new AnnotatedMember(member, pu.unitName()));
            }
        }
    }

    protected EntityManagerFactory getPersistenceUnit(String unitName) {
        if (this.persistenceUnits != null) {
            String jndiName;
            String unitNameForLookup;
            String string = unitNameForLookup = unitName != null ? unitName : "";
            if ("".equals(unitNameForLookup)) {
                unitNameForLookup = this.defaultPersistenceUnitName;
            }
            if ((jndiName = this.persistenceUnits.get(unitNameForLookup)) == null && "".equals(unitNameForLookup) && this.persistenceUnits.size() == 1) {
                jndiName = this.persistenceUnits.values().iterator().next();
            }
            if (jndiName != null) {
                try {
                    return (EntityManagerFactory)this.lookup(jndiName, EntityManagerFactory.class);
                }
                catch (NamingException ex) {
                    throw new IllegalStateException("Could not obtain EntityManagerFactory [" + jndiName + "] from JNDI", ex);
                }
            }
        }
        return null;
    }

    protected EntityManager getPersistenceContext(String unitName, boolean extended) {
        Map<String, String> contexts;
        Map<String, String> map = contexts = extended ? this.extendedPersistenceContexts : this.persistenceContexts;
        if (contexts != null) {
            String jndiName;
            String unitNameForLookup;
            String string = unitNameForLookup = unitName != null ? unitName : "";
            if ("".equals(unitNameForLookup)) {
                unitNameForLookup = this.defaultPersistenceUnitName;
            }
            if ((jndiName = contexts.get(unitNameForLookup)) == null && "".equals(unitNameForLookup) && contexts.size() == 1) {
                jndiName = contexts.values().iterator().next();
            }
            if (jndiName != null) {
                try {
                    return (EntityManager)this.lookup(jndiName, EntityManager.class);
                }
                catch (NamingException ex) {
                    throw new IllegalStateException("Could not obtain EntityManager [" + jndiName + "] from JNDI", ex);
                }
            }
        }
        return null;
    }

    protected EntityManagerFactory findEntityManagerFactory(String unitName) throws NoSuchBeanDefinitionException {
        String unitNameForLookup;
        if (this.beanFactory == null) {
            throw new IllegalStateException("ListableBeanFactory required for EntityManagerFactory lookup");
        }
        String string = unitNameForLookup = unitName != null ? unitName : "";
        if ("".equals(unitNameForLookup)) {
            unitNameForLookup = this.defaultPersistenceUnitName;
        }
        if (!"".equals(unitNameForLookup)) {
            return this.findNamedEntityManagerFactory(unitNameForLookup);
        }
        return this.findDefaultEntityManagerFactory();
    }

    protected EntityManagerFactory findNamedEntityManagerFactory(String unitName) throws NoSuchBeanDefinitionException {
        String[] candidateNames;
        for (String candidateName : candidateNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, EntityManagerFactory.class)) {
            EntityManagerFactoryInfo emfi;
            if (!this.beanFactory.isTypeMatch(candidateName, EntityManagerFactoryInfo.class) || !unitName.equals((emfi = (EntityManagerFactoryInfo)this.beanFactory.getBean(candidateName)).getPersistenceUnitName())) continue;
            return (EntityManagerFactory)emfi;
        }
        return (EntityManagerFactory)this.beanFactory.getBean(unitName);
    }

    protected EntityManagerFactory findDefaultEntityManagerFactory() {
        return (EntityManagerFactory)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, EntityManagerFactory.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotatedMember {
        private final Member member;
        private final String unitName;
        private final PersistenceContextType type;
        private final Properties properties;

        public AnnotatedMember(Member member, String unitName) {
            this(member, unitName, null, null);
        }

        public AnnotatedMember(Member member, String unitName, PersistenceContextType type, Properties properties) {
            this.member = member;
            this.unitName = unitName;
            this.type = type;
            this.properties = properties;
            Class<?> memberType = this.getMemberType();
            if (!EntityManagerFactory.class.isAssignableFrom(memberType) && !EntityManager.class.isAssignableFrom(memberType)) {
                throw new IllegalArgumentException("Cannot inject " + member + ": not a supported JPA type");
            }
        }

        public void inject(Object instance) {
            block6: {
                Object value = this.resolve();
                try {
                    if (!Modifier.isPublic(this.member.getModifiers()) || !Modifier.isPublic(this.member.getDeclaringClass().getModifiers())) {
                        ((AccessibleObject)((Object)this.member)).setAccessible(true);
                    }
                    if (this.member instanceof Field) {
                        ((Field)this.member).set(instance, value);
                        break block6;
                    }
                    if (this.member instanceof Method) {
                        ((Method)this.member).invoke(instance, value);
                        break block6;
                    }
                    throw new IllegalArgumentException("Cannot inject unknown AccessibleObject type " + this.member);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalArgumentException("Cannot inject member " + this.member, ex);
                }
                catch (InvocationTargetException ex) {
                    throw new IllegalArgumentException("Attempt to inject setter method " + this.member + " resulted in an exception", ex);
                }
            }
        }

        public Class<?> getMemberType() {
            if (this.member instanceof Field) {
                return ((Field)this.member).getType();
            }
            if (this.member instanceof Method) {
                Method setter = (Method)this.member;
                if (setter.getParameterTypes().length != 1) {
                    throw new IllegalArgumentException("Supposed setter [" + this.member + "] must have 1 argument, not " + setter.getParameterTypes().length);
                }
                return setter.getParameterTypes()[0];
            }
            throw new IllegalArgumentException("Unknown AccessibleObject type [" + this.member.getClass() + "]; can only inject setter methods and fields");
        }

        private Object resolve() {
            EntityManager em;
            if (EntityManagerFactory.class.isAssignableFrom(this.getMemberType())) {
                EntityManagerFactory emf = this.resolveEntityManagerFactory();
                if (!this.getMemberType().isInstance(emf)) {
                    throw new IllegalArgumentException("Cannot inject [" + this.member + "] with EntityManagerFactory [" + emf + "]: type mismatch");
                }
                return emf;
            }
            EntityManager entityManager = em = this.type == PersistenceContextType.EXTENDED ? this.resolveExtendedEntityManager() : this.resolveEntityManager();
            if (!this.getMemberType().isInstance(em)) {
                throw new IllegalArgumentException("Cannot inject [" + this.member + "] with EntityManager [" + em + "]: type mismatch");
            }
            return em;
        }

        private EntityManagerFactory resolveEntityManagerFactory() {
            EntityManagerFactory emf = PersistenceAnnotationBeanPostProcessor.this.getPersistenceUnit(this.unitName);
            if (emf == null) {
                emf = PersistenceAnnotationBeanPostProcessor.this.findEntityManagerFactory(this.unitName);
            }
            return emf;
        }

        private EntityManager resolveEntityManager() {
            EntityManager em = PersistenceAnnotationBeanPostProcessor.this.getPersistenceContext(this.unitName, false);
            if (em == null) {
                EntityManagerFactory emf = PersistenceAnnotationBeanPostProcessor.this.getPersistenceUnit(this.unitName);
                if (emf == null) {
                    emf = PersistenceAnnotationBeanPostProcessor.this.findEntityManagerFactory(this.unitName);
                }
                em = emf instanceof EntityManagerFactoryInfo && !EntityManager.class.equals(((EntityManagerFactoryInfo)emf).getEntityManagerInterface()) ? SharedEntityManagerCreator.createSharedEntityManager(emf, this.properties) : SharedEntityManagerCreator.createSharedEntityManager(emf, this.properties, this.getMemberType());
            }
            return em;
        }

        private EntityManager resolveExtendedEntityManager() {
            EntityManager em = PersistenceAnnotationBeanPostProcessor.this.getPersistenceContext(this.unitName, true);
            if (em == null) {
                EntityManagerFactory emf = PersistenceAnnotationBeanPostProcessor.this.getPersistenceUnit(this.unitName);
                if (emf == null) {
                    emf = PersistenceAnnotationBeanPostProcessor.this.findEntityManagerFactory(this.unitName);
                }
                em = ExtendedEntityManagerCreator.createContainerManagedEntityManager(emf, this.properties);
            }
            return em;
        }
    }
}

