/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.jdbc.datasource.lookup.SingleDataSourceLookup;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.DefaultPersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.springframework.util.ClassUtils;

public class LocalContainerEntityManagerFactoryBean
extends AbstractEntityManagerFactoryBean
implements ResourceLoaderAware,
BeanClassLoaderAware {
    private PersistenceUnitManager persistenceUnitManager;
    private final DefaultPersistenceUnitManager internalPersistenceUnitManager = new DefaultPersistenceUnitManager();
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private PersistenceUnitInfo persistenceUnitInfo;

    public void setPersistenceUnitManager(PersistenceUnitManager persistenceUnitManager) {
        this.persistenceUnitManager = persistenceUnitManager;
    }

    public void setPersistenceXmlLocation(String persistenceXmlLocation) {
        this.internalPersistenceUnitManager.setPersistenceXmlLocations(new String[]{persistenceXmlLocation});
    }

    public void setDataSource(DataSource dataSource) {
        this.internalPersistenceUnitManager.setDataSourceLookup((DataSourceLookup)new SingleDataSourceLookup(dataSource));
        this.internalPersistenceUnitManager.setDefaultDataSource(dataSource);
    }

    public void setLoadTimeWeaver(LoadTimeWeaver loadTimeWeaver) {
        this.internalPersistenceUnitManager.setLoadTimeWeaver(loadTimeWeaver);
    }

    public void setPersistenceUnitPostProcessors(PersistenceUnitPostProcessor[] postProcessors) {
        this.internalPersistenceUnitManager.setPersistenceUnitPostProcessors(postProcessors);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.internalPersistenceUnitManager.setResourceLoader(resourceLoader);
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        PersistenceUnitManager managerToUse = this.persistenceUnitManager;
        if (this.persistenceUnitManager == null) {
            this.internalPersistenceUnitManager.afterPropertiesSet();
            managerToUse = this.internalPersistenceUnitManager;
        }
        this.persistenceUnitInfo = this.determinePersistenceUnitInfo(managerToUse);
        PersistenceProvider provider = this.getPersistenceProvider();
        if (provider == null) {
            String providerClassName = this.persistenceUnitInfo.getPersistenceProviderClassName();
            Class providerClass = ClassUtils.resolveClassName((String)providerClassName, (ClassLoader)this.beanClassLoader);
            provider = (PersistenceProvider)BeanUtils.instantiateClass((Class)providerClass);
        }
        if (provider == null) {
            throw new IllegalStateException("Unable to determine persistence provider. Please check configuration of " + this.getClass().getName() + "; " + "ideally specify the appropriate JpaVendorAdapter class for this provider.");
        }
        this.nativeEntityManagerFactory = provider.createContainerEntityManagerFactory(this.persistenceUnitInfo, this.getJpaPropertyMap());
        this.postProcessEntityManagerFactory(this.nativeEntityManagerFactory, this.persistenceUnitInfo);
        return this.nativeEntityManagerFactory;
    }

    protected PersistenceUnitInfo determinePersistenceUnitInfo(PersistenceUnitManager persistenceUnitManager) {
        if (this.getPersistenceUnitName() != null) {
            return persistenceUnitManager.obtainPersistenceUnitInfo(this.getPersistenceUnitName());
        }
        return persistenceUnitManager.obtainDefaultPersistenceUnitInfo();
    }

    protected void postProcessEntityManagerFactory(EntityManagerFactory emf, PersistenceUnitInfo pui) {
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.persistenceUnitInfo;
    }

    public String getPersistenceUnitName() {
        if (this.persistenceUnitInfo != null) {
            return this.persistenceUnitInfo.getPersistenceUnitName();
        }
        return super.getPersistenceUnitName();
    }

    public DataSource getDataSource() {
        if (this.persistenceUnitInfo != null) {
            return this.persistenceUnitInfo.getNonJtaDataSource();
        }
        return this.internalPersistenceUnitManager.getDefaultDataSource();
    }
}

