/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.orm.jpa.persistenceunit.SpringPersistenceUnitInfo;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.util.xml.SimpleSaxErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistenceUnitReader {
    private static final String MAPPING_FILE_NAME = "mapping-file";
    private static final String JAR_FILE_URL = "jar-file";
    private static final String MANAGED_CLASS_NAME = "class";
    private static final String PROPERTIES = "properties";
    private static final String PROVIDER = "provider";
    private static final String EXCLUDE_UNLISTED_CLASSES = "exclude-unlisted-classes";
    private static final String NON_JTA_DATA_SOURCE = "non-jta-data-source";
    private static final String JTA_DATA_SOURCE = "jta-data-source";
    private static final String TRANSACTION_TYPE = "transaction-type";
    private static final String PERSISTENCE_UNIT = "persistence-unit";
    private static final String UNIT_NAME = "name";
    private static final String SCHEMA_NAME = "persistence_1_0.xsd";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String META_INF = "META-INF";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ResourcePatternResolver resourcePatternResolver;
    private final DataSourceLookup dataSourceLookup;

    public PersistenceUnitReader(ResourcePatternResolver resourcePatternResolver, DataSourceLookup dataSourceLookup) {
        Assert.notNull((Object)resourcePatternResolver, (String)"ResourceLoader must not be null");
        Assert.notNull((Object)dataSourceLookup, (String)"DataSourceLookup must not be null");
        this.resourcePatternResolver = resourcePatternResolver;
        this.dataSourceLookup = dataSourceLookup;
    }

    public SpringPersistenceUnitInfo[] readPersistenceUnitInfos(String persistenceXmlLocation) {
        return this.readPersistenceUnitInfos(new String[]{persistenceXmlLocation});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpringPersistenceUnitInfo[] readPersistenceUnitInfos(String[] persistenceXmlLocations) {
        SimpleSaxErrorHandler handler = new SimpleSaxErrorHandler(this.logger);
        LinkedList<SpringPersistenceUnitInfo> infos = new LinkedList<SpringPersistenceUnitInfo>();
        String resourceLocation = null;
        try {
            for (int i = 0; i < persistenceXmlLocations.length; ++i) {
                Resource[] resources;
                for (Resource resource : resources = this.resourcePatternResolver.getResources(persistenceXmlLocations[i])) {
                    resourceLocation = resource.toString();
                    InputStream stream = resource.getInputStream();
                    try {
                        Document document = this.validateResource((ErrorHandler)handler, stream);
                        this.parseDocument(resource, document, infos);
                    }
                    finally {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot parse persistence unit from " + resourceLocation, ex);
        }
        catch (SAXException ex) {
            throw new IllegalArgumentException("Invalid XML in persistence unit from " + resourceLocation, ex);
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalArgumentException("Internal error parsing persistence unit from " + resourceLocation);
        }
        return infos.toArray(new SpringPersistenceUnitInfo[infos.size()]);
    }

    protected Document validateResource(ErrorHandler handler, InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Resource schemaLocation = this.findSchemaResource(SCHEMA_NAME);
        if (schemaLocation != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found schema resource: " + schemaLocation.getURL()));
            }
            dbf.setValidating(true);
            dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
            dbf.setAttribute(JAXP_SCHEMA_SOURCE, schemaLocation.getURL().toString());
        } else {
            this.logger.debug((Object)"Schema resource [persistence_1_0.xsd] not found - falling back to XML parsing without schema validation");
        }
        DocumentBuilder parser = dbf.newDocumentBuilder();
        parser.setErrorHandler(handler);
        return parser.parse(stream);
    }

    protected Resource findSchemaResource(String schemaName) {
        block6: {
            try {
                Resource schemaLocation = this.resourcePatternResolver.getResource("classpath:" + schemaName);
                if (schemaLocation.exists()) {
                    return schemaLocation;
                }
                Resource[] resources = this.resourcePatternResolver.getResources("classpath*:org/**/" + schemaName);
                if (resources.length > 0) {
                    return resources[0];
                }
                resources = this.resourcePatternResolver.getResources("classpath*:com/**/" + schemaName);
                if (resources.length > 0) {
                    return resources[0];
                }
                resources = this.resourcePatternResolver.getResources("classpath*:**/" + schemaName);
                if (resources.length > 0) {
                    return resources[0];
                }
            }
            catch (IOException ex) {
                if (!this.logger.isDebugEnabled()) break block6;
                this.logger.debug((Object)("Could not search for JPA schema resource [" + schemaName + "] in class path"), (Throwable)ex);
            }
        }
        return null;
    }

    protected List<SpringPersistenceUnitInfo> parseDocument(Resource resource, Document document, List<SpringPersistenceUnitInfo> infos) throws IOException {
        Element persistence = document.getDocumentElement();
        URL unitRootURL = this.determinePersistenceUnitRootUrl(resource);
        List units = DomUtils.getChildElementsByTagName((Element)persistence, (String)PERSISTENCE_UNIT);
        for (Element unit : units) {
            SpringPersistenceUnitInfo info = this.parsePersistenceUnitInfo(unit);
            info.setPersistenceUnitRootUrl(unitRootURL);
            infos.add(info);
        }
        return infos;
    }

    protected URL determinePersistenceUnitRootUrl(Resource resource) throws IOException {
        URL originalURL = resource.getURL();
        String urlToString = originalURL.toExternalForm();
        if (ResourceUtils.isJarURL((URL)originalURL)) {
            return ResourceUtils.extractJarFileURL((URL)originalURL);
        }
        if (!urlToString.contains(META_INF)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)(resource.getFilename() + " should be located inside META-INF directory; cannot determine persistence unit root URL for " + resource));
            }
            return null;
        }
        if (urlToString.lastIndexOf(META_INF) == urlToString.lastIndexOf(47) - (1 + META_INF.length())) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)(resource.getFilename() + " is not located in the root of META-INF directory; cannot determine persistence unit root URL for " + resource));
            }
            return null;
        }
        String persistenceUnitRoot = urlToString.substring(0, urlToString.lastIndexOf(META_INF));
        return new URL(persistenceUnitRoot);
    }

    protected SpringPersistenceUnitInfo parsePersistenceUnitInfo(Element persistenceUnit) throws IOException {
        Element excludeUnlistedClasses;
        String provider;
        String nonJtaDataSource;
        String jtaDataSource;
        SpringPersistenceUnitInfo unitInfo = new SpringPersistenceUnitInfo();
        unitInfo.setPersistenceUnitName(persistenceUnit.getAttribute(UNIT_NAME).trim());
        String txType = persistenceUnit.getAttribute(TRANSACTION_TYPE).trim();
        if (StringUtils.hasText((String)txType)) {
            unitInfo.setTransactionType(PersistenceUnitTransactionType.valueOf((String)txType));
        }
        if (StringUtils.hasText((String)(jtaDataSource = DomUtils.getChildElementValueByTagName((Element)persistenceUnit, (String)JTA_DATA_SOURCE)))) {
            unitInfo.setJtaDataSource(this.dataSourceLookup.getDataSource(jtaDataSource.trim()));
        }
        if (StringUtils.hasText((String)(nonJtaDataSource = DomUtils.getChildElementValueByTagName((Element)persistenceUnit, (String)NON_JTA_DATA_SOURCE)))) {
            unitInfo.setNonJtaDataSource(this.dataSourceLookup.getDataSource(nonJtaDataSource.trim()));
        }
        if (StringUtils.hasText((String)(provider = DomUtils.getChildElementValueByTagName((Element)persistenceUnit, (String)PROVIDER)))) {
            unitInfo.setPersistenceProviderClassName(provider.trim());
        }
        if ((excludeUnlistedClasses = DomUtils.getChildElementByTagName((Element)persistenceUnit, (String)EXCLUDE_UNLISTED_CLASSES)) != null) {
            unitInfo.setExcludeUnlistedClasses(true);
        }
        this.parseMappingFiles(persistenceUnit, unitInfo);
        this.parseJarFiles(persistenceUnit, unitInfo);
        this.parseClass(persistenceUnit, unitInfo);
        this.parseProperty(persistenceUnit, unitInfo);
        return unitInfo;
    }

    protected void parseProperty(Element persistenceUnit, SpringPersistenceUnitInfo unitInfo) {
        Element propRoot = DomUtils.getChildElementByTagName((Element)persistenceUnit, (String)PROPERTIES);
        if (propRoot == null) {
            return;
        }
        List properties = DomUtils.getChildElementsByTagName((Element)propRoot, (String)"property");
        for (Element property : properties) {
            String name = property.getAttribute(UNIT_NAME);
            String value = property.getAttribute("value");
            unitInfo.addProperty(name, value);
        }
    }

    protected void parseClass(Element persistenceUnit, SpringPersistenceUnitInfo unitInfo) {
        List classes = DomUtils.getChildElementsByTagName((Element)persistenceUnit, (String)MANAGED_CLASS_NAME);
        for (Element element : classes) {
            String value = DomUtils.getTextValue((Element)element).trim();
            if (!StringUtils.hasText((String)value)) continue;
            unitInfo.addManagedClassName(value);
        }
    }

    protected void parseJarFiles(Element persistenceUnit, SpringPersistenceUnitInfo unitInfo) throws IOException {
        List jars = DomUtils.getChildElementsByTagName((Element)persistenceUnit, (String)JAR_FILE_URL);
        for (Element element : jars) {
            String value = DomUtils.getTextValue((Element)element).trim();
            if (!StringUtils.hasText((String)value)) continue;
            Resource resource = this.resourcePatternResolver.getResource(value);
            unitInfo.addJarFileUrl(resource.getURL());
        }
    }

    protected void parseMappingFiles(Element persistenceUnit, SpringPersistenceUnitInfo unitInfo) {
        List files = DomUtils.getChildElementsByTagName((Element)persistenceUnit, (String)MAPPING_FILE_NAME);
        for (Element element : files) {
            String value = DomUtils.getTextValue((Element)element).trim();
            if (!StringUtils.hasText((String)value)) continue;
            unitInfo.addMappingFileName(value);
        }
    }
}

